/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.pool;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.jmxtrans.embedded.util.net.HostAndPort;
import org.jmxtrans.embedded.util.net.SocketWriter;

public class SocketWriterPoolFactory
extends BaseKeyedPoolableObjectFactory<HostAndPort, SocketWriter>
implements KeyedPoolableObjectFactory<HostAndPort, SocketWriter> {
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT_IN_MILLIS = 500;
    private final Charset charset;
    private final int socketConnectTimeoutInMillis;

    public SocketWriterPoolFactory(String charset, int socketConnectTimeoutInMillis) {
        this(Charset.forName(charset), socketConnectTimeoutInMillis);
    }

    public SocketWriterPoolFactory(Charset charset, int socketConnectTimeoutInMillis) {
        this.charset = charset;
        this.socketConnectTimeoutInMillis = socketConnectTimeoutInMillis;
    }

    public SocketWriter makeObject(HostAndPort HostAndPort2) throws Exception {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        socket.connect(new InetSocketAddress(HostAndPort2.getHost(), HostAndPort2.getPort()), this.socketConnectTimeoutInMillis);
        return new SocketWriter(socket, this.charset);
    }

    public void destroyObject(HostAndPort HostAndPort2, SocketWriter socketWriter) throws Exception {
        super.destroyObject((Object)HostAndPort2, (Object)socketWriter);
        socketWriter.close();
        socketWriter.getSocket().close();
    }

    public boolean validateObject(HostAndPort HostAndPort2, SocketWriter socketWriter) {
        Socket socket = socketWriter.getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

