/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.concurrent;

import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jmxtrans.embedded.util.concurrent.DiscardingBlockingQueueMBean;

public class DiscardingBlockingQueue<E>
extends ArrayBlockingQueue<E>
implements DiscardingBlockingQueueMBean {
    private final AtomicInteger discardedElementCount = new AtomicInteger();

    public DiscardingBlockingQueue(int capacity) {
        super(capacity);
    }

    public DiscardingBlockingQueue(int capacity, boolean fair) {
        super(capacity, fair);
    }

    public DiscardingBlockingQueue(int capacity, boolean fair, Collection<? extends E> c) {
        super(capacity, fair, c);
    }

    protected void discardingOffer(E e) {
        while (!super.offer(e)) {
            this.poll();
            this.discardedElementCount.incrementAndGet();
        }
    }

    @Override
    public boolean add(E e) {
        this.discardingOffer(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        this.discardingOffer(e);
        return true;
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.discardingOffer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        this.discardingOffer(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.discardingOffer(e);
        }
        return !c.isEmpty();
    }

    @Override
    public int getDiscardedElementCount() {
        return this.discardedElementCount.get();
    }
}

