/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.util.pool;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.jmxtrans.embedded.util.net.HostAndPort;
import org.jmxtrans.embedded.util.net.SocketOutputStream;

public class SocketOutputStreamPoolFactory
extends BaseKeyedPoolableObjectFactory<HostAndPort, SocketOutputStream>
implements KeyedPoolableObjectFactory<HostAndPort, SocketOutputStream> {
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT_IN_MILLIS = 500;
    private final int socketConnectTimeoutInMillis;

    public SocketOutputStreamPoolFactory(int socketConnectTimeoutInMillis) {
        this.socketConnectTimeoutInMillis = socketConnectTimeoutInMillis;
    }

    public SocketOutputStream makeObject(HostAndPort HostAndPort2) throws Exception {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        socket.connect(new InetSocketAddress(HostAndPort2.getHost(), HostAndPort2.getPort()), this.socketConnectTimeoutInMillis);
        return new SocketOutputStream(socket);
    }

    public void destroyObject(HostAndPort HostAndPort2, SocketOutputStream socketOutputStream) throws Exception {
        super.destroyObject((Object)HostAndPort2, (Object)socketOutputStream);
        socketOutputStream.close();
        socketOutputStream.getSocket().close();
    }

    public boolean validateObject(HostAndPort HostAndPort2, SocketOutputStream socketOutputStream) {
        Socket socket = socketOutputStream.getSocket();
        return socket.isConnected() && socket.isBound() && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

