/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import org.jmxtrans.embedded.EmbeddedJmxTransMBean;
import org.jmxtrans.embedded.Query;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedJmxTrans
implements EmbeddedJmxTransMBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private ScheduledExecutorService collectScheduledExecutor;
    private ScheduledExecutorService exportScheduledExecutor;
    @Nonnull
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    @Nonnull
    private final List<Query> queries = new ArrayList<Query>();
    private Set<OutputWriter> outputWriters = new HashSet<OutputWriter>();
    private int numQueryThreads = 1;
    private int numExportThreads = 1;
    private int queryIntervalInSeconds = 30;
    private int exportIntervalInSeconds = 5;
    private int exportBatchSize = 50;
    private EmbeddedJmxTransShutdownHook shutdownHook;

    public EmbeddedJmxTrans() {
    }

    public EmbeddedJmxTrans(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public synchronized void start() throws Exception {
        this.readWriteLock.writeLock().lock();
        try {
            State state = this.state.get();
            if (!State.STOPPED.equals((Object)state)) {
                this.logger.warn("Ignore start() command for {} instance", (Object)state);
                return;
            }
            this.state.set(State.STARTING);
            for (final Query query : this.queries) {
                query.start();
            }
            for (OutputWriter outputWriter : this.outputWriters) {
                outputWriter.start();
            }
            this.collectScheduledExecutor = Executors.newScheduledThreadPool(this.getNumQueryThreads(), new NamedThreadFactory("jmxtrans-collect-", true));
            this.exportScheduledExecutor = Executors.newScheduledThreadPool(this.getNumExportThreads(), new NamedThreadFactory("jmxtrans-export-", true));
            for (final Query query : this.getQueries()) {
                this.collectScheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        EmbeddedJmxTrans.this.readWriteLock.readLock().lock();
                        try {
                            State state = (State)((Object)EmbeddedJmxTrans.this.state.get());
                            if (!State.STARTED.equals((Object)state)) {
                                EmbeddedJmxTrans.this.logger.debug("Ignore query.collectMetrics() command for {} instance", (Object)state);
                                return;
                            }
                            query.collectMetrics();
                        }
                        finally {
                            EmbeddedJmxTrans.this.readWriteLock.readLock().unlock();
                        }
                    }

                    public String toString() {
                        return "Collector[" + query + "]";
                    }
                }, 0L, this.getQueryIntervalInSeconds(), TimeUnit.SECONDS);
                this.exportScheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        EmbeddedJmxTrans.this.readWriteLock.readLock().lock();
                        try {
                            State state = (State)((Object)EmbeddedJmxTrans.this.state.get());
                            if (!State.STARTED.equals((Object)state)) {
                                EmbeddedJmxTrans.this.logger.debug("Ignore query.exportCollectedMetrics() command for {} instance", (Object)state);
                                return;
                            }
                            query.exportCollectedMetrics();
                        }
                        finally {
                            EmbeddedJmxTrans.this.readWriteLock.readLock().unlock();
                        }
                    }

                    public String toString() {
                        return "Exporter[" + query + "]";
                    }
                }, this.getQueryIntervalInSeconds() + 1, this.getExportIntervalInSeconds(), TimeUnit.SECONDS);
            }
            this.shutdownHook = new EmbeddedJmxTransShutdownHook();
            this.shutdownHook.registerToRuntime();
            this.state.set(State.STARTED);
            this.logger.info("EmbeddedJmxTrans started");
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public synchronized void stop() throws Exception {
        this.readWriteLock.writeLock().lock();
        try {
            State state = this.state.get();
            if (!State.STARTED.equals((Object)state)) {
                this.logger.debug("Ignore stop() command for " + (Object)((Object)state) + " instance");
                return;
            }
            this.state.set(State.STOPPING);
            try {
                List<Runnable> tasks;
                boolean terminated;
                this.collectScheduledExecutor.shutdown();
                try {
                    terminated = this.collectScheduledExecutor.awaitTermination(this.getQueryIntervalInSeconds(), TimeUnit.SECONDS);
                    if (!terminated) {
                        tasks = this.collectScheduledExecutor.shutdownNow();
                        this.logger.warn("Collect executor could not shutdown in time. Abort tasks " + tasks);
                    }
                }
                catch (InterruptedException e) {
                    this.logger.warn("Ignore InterruptedException stopping", (Throwable)e);
                }
                this.exportScheduledExecutor.shutdown();
                try {
                    terminated = this.exportScheduledExecutor.awaitTermination(this.getExportIntervalInSeconds(), TimeUnit.SECONDS);
                    if (!terminated) {
                        tasks = this.exportScheduledExecutor.shutdownNow();
                        this.logger.warn("Export executor could not shutdown in time. Abort tasks " + tasks);
                    }
                }
                catch (InterruptedException e) {
                    this.logger.warn("Ignore InterruptedException stopping", (Throwable)e);
                }
            }
            catch (RuntimeException e) {
                this.logger.warn("Failure while shutting down ExecutorServices", (Throwable)e);
            }
            this.shutdownHook.onStop();
            this.state.set(State.STOPPED);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectMetrics() {
        this.readWriteLock.readLock().lock();
        try {
            State state = this.state.get();
            if (!State.STARTED.equals((Object)state)) {
                this.logger.debug("Ignore collectMetrics() command for " + (Object)((Object)state) + " instance");
                return;
            }
            for (Query query : this.getQueries()) {
                query.collectMetrics();
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportCollectedMetrics() {
        this.readWriteLock.readLock().lock();
        try {
            State state = this.state.get();
            if (!State.STARTED.equals((Object)state)) {
                this.logger.debug("Ignore collectMetrics() command for not running instance");
                return;
            }
            for (Query query : this.getQueries()) {
                query.exportCollectedMetrics();
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Nonnull
    public List<Query> getQueries() {
        return this.queries;
    }

    public void addQuery(@Nonnull Query query) {
        query.setEmbeddedJmxTrans(this);
        this.queries.add(query);
    }

    public String toString() {
        return "EmbeddedJmxTrans{state=" + this.state + ", queries=" + this.queries + ", outputWriters=" + this.outputWriters + ", numQueryThreads=" + this.numQueryThreads + ", queryIntervalInSeconds=" + this.queryIntervalInSeconds + ", numExportThreads=" + this.numExportThreads + ", exportIntervalInSeconds=" + this.exportIntervalInSeconds + ", exportBatchSize=" + this.exportBatchSize + '}';
    }

    @Override
    public int getNumQueryThreads() {
        return this.numQueryThreads;
    }

    public void setNumQueryThreads(int numQueryThreads) {
        this.numQueryThreads = numQueryThreads;
    }

    @Override
    public int getQueryIntervalInSeconds() {
        return this.queryIntervalInSeconds;
    }

    public void setQueryIntervalInSeconds(int queryIntervalInSeconds) {
        this.queryIntervalInSeconds = queryIntervalInSeconds;
    }

    @Override
    public int getExportIntervalInSeconds() {
        return this.exportIntervalInSeconds;
    }

    public void setExportIntervalInSeconds(int exportIntervalInSeconds) {
        this.exportIntervalInSeconds = exportIntervalInSeconds;
    }

    @Override
    public int getNumExportThreads() {
        return this.numExportThreads;
    }

    public void setNumExportThreads(int numExportThreads) {
        this.numExportThreads = numExportThreads;
    }

    @Nonnull
    public Set<OutputWriter> getOutputWriters() {
        return this.outputWriters;
    }

    public int getExportBatchSize() {
        return this.exportBatchSize;
    }

    public void setExportBatchSize(int exportBatchSize) {
        this.exportBatchSize = exportBatchSize;
    }

    @Nonnull
    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    @Override
    public int getCollectedMetricsCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getCollectedMetricsCount();
        }
        return result;
    }

    @Override
    public long getCollectionDurationInNanos() {
        long result = 0L;
        for (Query query : this.queries) {
            result += query.getCollectionDurationInNanos();
        }
        return result;
    }

    @Override
    public long getCollectionDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getCollectionDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int getCollectionCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getCollectionCount();
        }
        return result;
    }

    @Override
    public int getExportedMetricsCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getExportedMetricsCount();
        }
        return result;
    }

    @Override
    public long getExportDurationInNanos() {
        long result = 0L;
        for (Query query : this.queries) {
            result += query.getExportDurationInNanos();
        }
        return result;
    }

    @Override
    public long getExportDurationInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.getExportDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int getExportCount() {
        int result = 0;
        for (Query query : this.queries) {
            result += query.getExportCount();
        }
        return result;
    }

    @Override
    public int getDiscardedResultsCount() {
        int result = 0;
        for (Query query : this.queries) {
            int discardedResultsCount = query.getDiscardedResultsCount();
            if (discardedResultsCount == -1) continue;
            result += discardedResultsCount;
        }
        return result;
    }

    static enum State {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }

    private class EmbeddedJmxTransShutdownHook
    extends Thread {
        private final AtomicBoolean alreadyExecuted = new AtomicBoolean(false);

        public EmbeddedJmxTransShutdownHook() {
            this.setName(this.getClass().getSimpleName() + "-" + this.getName());
        }

        @Override
        public void run() {
            this.execute("EmbeddedJmxTransShutdownHook");
        }

        private void execute(String invokerName) {
            if (this.alreadyExecuted.compareAndSet(false, true)) {
                try {
                    EmbeddedJmxTrans.this.collectMetrics();
                    EmbeddedJmxTrans.this.exportCollectedMetrics();
                    EmbeddedJmxTrans.this.logger.info("{} successfully collected and exported metrics one last time", (Object)invokerName);
                }
                catch (RuntimeException e) {
                    EmbeddedJmxTrans.this.logger.warn("{} failed to collect and export metrics one last time", (Object)invokerName);
                }
                try {
                    for (Query query : EmbeddedJmxTrans.this.queries) {
                        query.stop();
                    }
                }
                catch (Exception e) {
                    EmbeddedJmxTrans.this.logger.warn("Failure while stopping queries", (Throwable)e);
                }
                try {
                    for (OutputWriter outputWriter : EmbeddedJmxTrans.this.outputWriters) {
                        outputWriter.stop();
                    }
                }
                catch (Exception e) {
                    EmbeddedJmxTrans.this.logger.warn("Failure while stopping outputWriters", (Throwable)e);
                }
            }
        }

        public boolean isAlreadyExecuted() {
            return this.alreadyExecuted.get();
        }

        public void registerToRuntime() {
            Runtime.getRuntime().addShutdownHook(this);
        }

        public void unregisterFromRuntime() {
            try {
                boolean shutdownHookRemoved = Runtime.getRuntime().removeShutdownHook(this);
                if (shutdownHookRemoved) {
                    EmbeddedJmxTrans.this.logger.debug("ShutdownHook successfully removed");
                } else {
                    EmbeddedJmxTrans.this.logger.warn("Failure to remove ShutdownHook");
                }
            }
            catch (RuntimeException e) {
                EmbeddedJmxTrans.this.logger.warn("Failure to remove ShutdownHook", (Throwable)e);
            }
        }

        public void onStop() {
            if (!this.isAlreadyExecuted()) {
                this.unregisterFromRuntime();
                this.execute("EmbeddedJmxTrans Stop Handler");
            }
        }
    }
}

