/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.management.ObjectName;
import org.jmxtrans.embedded.DeferredResultNameStrategyExpressionEvaluatorInitializer;
import org.jmxtrans.embedded.Query;
import org.jmxtrans.embedded.QueryAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultNameStrategy {
    public static final String REPLACE_DOTS_IN_OBJECT_NAME = "replaceDotsInObjectName";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean replaceDotsInObjectNames = true;
    @Nonnull
    private Map<String, Callable<String>> expressionEvaluators = new DeferredResultNameStrategyExpressionEvaluatorInitializer().createInitialExpressionEvaluatorsMap();

    public String getResultName(Query query, ObjectName objectName, QueryAttribute queryAttribute) {
        StringBuilder result = this._getResultName(query, objectName, queryAttribute);
        return result.toString();
    }

    public String getResultName(Query query, ObjectName objectName, QueryAttribute queryAttribute, String key) {
        StringBuilder result = this._getResultName(query, objectName, queryAttribute);
        result.append(".");
        result.append(key);
        return result.toString();
    }

    protected StringBuilder _getResultName(Query query, ObjectName objectName, QueryAttribute queryAttribute) {
        StringBuilder result = new StringBuilder();
        String queryName = query.getResultAlias() == null ? this.escapeObjectName(objectName) : this.resolveExpression(query.getResultAlias(), objectName);
        if (queryName != null && !queryName.isEmpty()) {
            result.append(queryName).append(".");
        }
        String attributeName = queryAttribute.getResultAlias() == null ? queryAttribute.getName() : queryAttribute.getResultAlias();
        result.append(attributeName);
        return result;
    }

    public String resolveExpression(String expression) {
        StringBuilder result = new StringBuilder(expression.length());
        int position = 0;
        while (position < expression.length()) {
            char c = expression.charAt(position);
            if (c == '#') {
                String value;
                int beginningSeparatorPosition = position;
                int endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                String key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Callable<String> expressionProcessor = this.expressionEvaluators.get(key);
                if (expressionProcessor == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + key + "'");
                } else {
                    try {
                        value = expressionProcessor.call();
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.warn("Error evaluating expression '" + key + "'", (Throwable)e);
                    }
                }
                this.appendEscapedNonAlphaNumericChars(value, false, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        this.logger.trace("resolveExpression({}): {}", (Object)expression, (Object)result);
        return result.toString();
    }

    protected String resolveExpression(String expression, ObjectName exactObjectName) {
        StringBuilder result = new StringBuilder(expression.length());
        int position = 0;
        while (position < expression.length()) {
            String key;
            int endingSeparatorPosition;
            int beginningSeparatorPosition;
            char c = expression.charAt(position);
            if (c == '%') {
                beginningSeparatorPosition = position;
                endingSeparatorPosition = expression.indexOf(37, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '%' after beginning '%' at position " + beginningSeparatorPosition);
                }
                key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                String value = exactObjectName.getKeyProperty(key);
                if (value == null) {
                    value = "null";
                }
                this.appendEscapedNonAlphaNumericChars(value, this.replaceDotsInObjectNames, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            if (c == '#') {
                String value;
                beginningSeparatorPosition = position;
                endingSeparatorPosition = expression.indexOf(35, beginningSeparatorPosition + 1);
                if (endingSeparatorPosition == -1) {
                    throw new IllegalStateException("Invalid expression '" + expression + "', no ending '#' after beginning '#' at position " + beginningSeparatorPosition);
                }
                key = expression.substring(beginningSeparatorPosition + 1, endingSeparatorPosition);
                Callable<String> expressionProcessor = this.expressionEvaluators.get(key);
                if (expressionProcessor == null) {
                    value = "#unsupported_expression#";
                    this.logger.info("Unsupported expression '" + key + "'");
                } else {
                    try {
                        value = expressionProcessor.call();
                    }
                    catch (Exception e) {
                        value = "#expression_error#";
                        this.logger.warn("Error evaluating expression '" + key + "'", (Throwable)e);
                    }
                }
                this.appendEscapedNonAlphaNumericChars(value, false, result);
                position = endingSeparatorPosition + 1;
                continue;
            }
            result.append(c);
            ++position;
        }
        this.logger.trace("resolveExpression({}, {}): {}", new Object[]{expression, exactObjectName, result});
        return result.toString();
    }

    protected String escapeObjectName(ObjectName objectName) {
        StringBuilder result = new StringBuilder();
        this.appendEscapedNonAlphaNumericChars(objectName.getDomain(), result);
        result.append('.');
        ArrayList<String> keys = Collections.list(objectName.getKeyPropertyList().keys());
        Collections.sort(keys);
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.appendEscapedNonAlphaNumericChars(key, result);
            result.append("__");
            this.appendEscapedNonAlphaNumericChars(objectName.getKeyProperty(key), result);
            if (!it.hasNext()) continue;
            result.append('.');
        }
        this.logger.trace("escapeObjectName({}): {}", (Object)objectName, (Object)result);
        return result.toString();
    }

    private void appendEscapedNonAlphaNumericChars(String str, StringBuilder result) {
        this.appendEscapedNonAlphaNumericChars(str, true, result);
    }

    private void appendEscapedNonAlphaNumericChars(String str, boolean escapeDot, StringBuilder result) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-') {
                result.append(ch);
                continue;
            }
            if (ch == '.') {
                result.append(escapeDot ? (char)'_' : ch);
                continue;
            }
            if (ch == '\"' && (i == 0 || i == chars.length - 1)) continue;
            result.append('_');
        }
    }

    public void registerExpressionEvaluator(String expression, Callable<String> evaluator) {
        this.expressionEvaluators.put(expression, evaluator);
    }

    public void registerExpressionEvaluator(String expression, String value) {
        this.expressionEvaluators.put(expression, new StaticEvaluator(value));
    }

    @Nonnull
    public Map<String, Callable<String>> getExpressionEvaluators() {
        return this.expressionEvaluators;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        ResultNameStrategy delegate = new ResultNameStrategy();

        public Builder replaceDotsInObjectNames(boolean replaceDots) {
            this.delegate.replaceDotsInObjectNames = replaceDots;
            return this;
        }

        public ResultNameStrategy build() {
            return this.delegate;
        }
    }

    public static class StaticEvaluator
    implements Callable<String> {
        final String value;

        public StaticEvaluator(String value) {
            this.value = value;
        }

        @Override
        public String call() throws Exception {
            return this.value;
        }

        public String toString() {
            return "StaticStringCallable{value='" + this.value + '\'' + '}';
        }
    }
}

