/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.output;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jmxtrans.embedded.EmbeddedJmxTransException;
import org.jmxtrans.embedded.QueryResult;
import org.jmxtrans.embedded.output.AbstractOutputWriter;
import org.jmxtrans.embedded.output.OutputWriter;
import org.jmxtrans.embedded.util.io.IoUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopperEggWriter
extends AbstractOutputWriter
implements OutputWriter {
    public static final String METRIC_TYPE_GAUGE = "gauge";
    public static final String METRIC_TYPE_COUNTER = "counter";
    public static final String DEFAULT_COPPEREGG_API_URL = "https://api.copperegg.com/v2/revealmetrics";
    public static final String SETTING_COPPEREGG_API_TIMEOUT_IN_MILLIS = "coppereggApiTimeoutInMillis";
    public static final int DEFAULT_COPPEREGG_API_TIMEOUT_IN_MILLIS = 20000;
    public static final String SETTING_SOURCE = "source";
    public static final String DEFAULT_SOURCE = "#hostname#";
    private static final String DEFAULT_COPPEREGG_CONFIGURATION_PATH = "classpath:copperegg_config.json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger exceptionCounter = new AtomicInteger();
    private JsonFactory jsonFactory = new JsonFactory();
    private URL url;
    private String url_str;
    private int coppereggApiTimeoutInMillis = 20000;
    private long myPID = 0L;
    private String myhost;
    private String myPID_host;
    private String config_location;
    private static Map<String, String> dashMap = new HashMap<String, String>();
    private static Map<String, String> metricgroupMap = new HashMap<String, String>();
    private String jvm_os_groupID = null;
    private String jvm_gc_groupID = null;
    private String jvm_runtime_groupID = null;
    private String jvm_class_groupID = null;
    private String jvm_thread_groupID = null;
    private String heap_metric_groupID = null;
    private String nonheap_metric_groupID = null;
    private String tomcat_thread_pool_groupID = null;
    private String tomcat_grp_groupID = null;
    private String tomcat_manager_groupID = null;
    private String tomcat_servlet_groupID = null;
    private String tomcat_db_groupID = null;
    private String jmxtrans_metric_groupID = null;
    private String app_groupID = null;
    private String app_sales_groupID = null;
    private String user;
    private String token;
    private String basicAuthentication;
    @Nullable
    private Proxy proxy;
    @Nullable
    private String source;

    @Override
    public void start() {
        this.config_location = DEFAULT_COPPEREGG_CONFIGURATION_PATH;
        String path = this.config_location.substring("classpath:".length());
        long thisPID = CopperEggWriter.getPID();
        if (this.myPID == thisPID) {
            this.logger.info("Started from two threads with the same PID, {}", (Object)thisPID);
            return;
        }
        this.myPID = thisPID;
        try {
            String str = String.valueOf(this.myPID);
            this.url_str = this.getStringSetting("url", DEFAULT_COPPEREGG_API_URL);
            this.url = new URL(this.url_str);
            this.user = this.getStringSetting("username");
            this.user = this.token = this.getStringSetting("token");
            this.basicAuthentication = Base64Variants.getDefaultVariant().encode((this.user + ":U").getBytes(Charset.forName("US-ASCII")));
            if (this.getStringSetting("proxyHost", null) != null && !this.getStringSetting("proxyHost").isEmpty()) {
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getStringSetting("proxyHost"), this.getIntSetting("proxyPort")));
            }
            this.coppereggApiTimeoutInMillis = this.getIntSetting(SETTING_COPPEREGG_API_TIMEOUT_IN_MILLIS, 20000);
            this.source = this.getStringSetting(SETTING_SOURCE, DEFAULT_SOURCE);
            this.myhost = this.source = this.getStrategy().resolveExpression(this.source);
            this.myPID_host = this.myhost + '.' + str;
            try {
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                if (in == null) {
                    this.logger.warn("No file found for classpath:" + this.config_location);
                } else {
                    this.read_config(in);
                }
            }
            catch (Exception e) {
                this.exceptionCounter.incrementAndGet();
                this.logger.warn("Exception in start " + e);
            }
            this.ensure_metric_groups();
            this.ensure_dashboards();
            this.logger.info("jvm_os_groupID : {}", (Object)this.jvm_os_groupID);
            this.logger.info("jvm_gc_groupID : {}", (Object)this.jvm_gc_groupID);
            this.logger.info("jvm_runtime_groupID : {}", (Object)this.jvm_runtime_groupID);
            this.logger.info("jvm_class_groupID : {}", (Object)this.jvm_class_groupID);
            this.logger.info("jvm_thread_groupID : {}", (Object)this.jvm_thread_groupID);
            this.logger.info("heap_metric_groupID : {}", (Object)this.heap_metric_groupID);
            this.logger.info("nonheap_metric_groupID : {}", (Object)this.nonheap_metric_groupID);
            this.logger.info("tomcat_thread_pool_groupID : {}", (Object)this.tomcat_thread_pool_groupID);
            this.logger.info("tomcat_grp_groupID : {}", (Object)this.tomcat_grp_groupID);
            this.logger.info("tomcat_servlet_groupID : {}", (Object)this.tomcat_servlet_groupID);
            this.logger.info("tomcat_manager_groupID : {}", (Object)this.tomcat_manager_groupID);
            this.logger.info("tomcat_db_groupID  : {}", (Object)this.tomcat_db_groupID);
            this.logger.info("jmxtrans_metric_groupID : {}", (Object)this.jmxtrans_metric_groupID);
            this.logger.info("app_groupID : {}", (Object)this.app_groupID);
            this.logger.info("app_sales_groupID : {}", (Object)this.app_sales_groupID);
            this.logger.info("Started CopperEggWriter Successfully on jvm '{}', connected to '{}', proxy {}", new Object[]{this.myPID_host, this.url, this.proxy});
        }
        catch (MalformedURLException e) {
            this.exceptionCounter.incrementAndGet();
            throw new EmbeddedJmxTransException(e);
        }
    }

    @Override
    public void write(Iterable<QueryResult> results) {
        ArrayList<QueryResult> jvm_os_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> jvm_gc_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> jvm_runtime_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> jvm_class_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> jvm_thread_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> heap_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> nonheap_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> tomcat_thread_pool_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> tomcat_grp_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> tomcat_manager_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> tomcat_servlet_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> tomcat_db_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> jmxtrans_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> app_counters = new ArrayList<QueryResult>();
        ArrayList<QueryResult> app_sales_counters = new ArrayList<QueryResult>();
        long epochInMillis = 0L;
        String myname = null;
        Object myval = null;
        long thisPID = 0L;
        String tmp = null;
        String pidHost = null;
        String delims = "[.]";
        for (QueryResult result : results) {
            epochInMillis = result.getEpochInMillis();
            myname = result.getName();
            myval = result.getValue();
            String valstr = myval.toString();
            thisPID = CopperEggWriter.getPID();
            tmp = String.valueOf(thisPID);
            pidHost = this.source + "." + tmp;
            String[] parts = myname.split(delims);
            if (parts.length > 0) {
                String p1 = parts[0];
                if (this.jmxtrans_metric_groupID != null && p1.equals("jmxtrans")) {
                    QueryResult new_result = new QueryResult(myname, pidHost, myval, epochInMillis);
                    jmxtrans_counters.add(new_result);
                    continue;
                }
                if (p1.equals("jvm")) {
                    if (parts[1].equals("os")) {
                        if (parts[2].equals("OpenFileDescriptorCount")) {
                            QueryResult new_result = new QueryResult(myname, pidHost, myval, epochInMillis);
                            jvm_os_counters.add(new_result);
                            continue;
                        }
                        if (parts[2].equals("CommittedVirtualMemorySize")) {
                            float fval = Float.parseFloat(valstr);
                            try {
                                fval /= 1048576.0f;
                            }
                            catch (Exception e) {
                                this.exceptionCounter.incrementAndGet();
                                this.logger.info("Exception doing Float: ", (Throwable)e);
                            }
                            QueryResult new_result = new QueryResult(myname, pidHost, Float.valueOf(fval), epochInMillis);
                            jvm_os_counters.add(new_result);
                            continue;
                        }
                        if (!parts[2].equals("ProcessCpuTime")) continue;
                        float fval = Float.parseFloat(valstr);
                        try {
                            fval /= 1.0E9f;
                        }
                        catch (Exception e) {
                            this.exceptionCounter.incrementAndGet();
                            this.logger.warn("Exception doing Float: ", (Throwable)e);
                        }
                        QueryResult new_result = new QueryResult(myname, pidHost, Float.valueOf(fval), epochInMillis);
                        jvm_os_counters.add(new_result);
                        continue;
                    }
                    if (parts[1].equals("runtime") && parts[2].equals("Uptime")) {
                        float fval = Float.parseFloat(valstr);
                        try {
                            fval /= 60000.0f;
                        }
                        catch (Exception e) {
                            this.exceptionCounter.incrementAndGet();
                            this.logger.warn("Exception doing Float: ", (Throwable)e);
                        }
                        QueryResult new_result = new QueryResult(myname, pidHost, Float.valueOf(fval), epochInMillis);
                        jvm_runtime_counters.add(new_result);
                        continue;
                    }
                    if (parts[1].equals("loadedClasses") && parts[2].equals("LoadedClassCount")) {
                        QueryResult new_result = new QueryResult(myname, pidHost, myval, epochInMillis);
                        jvm_class_counters.add(new_result);
                        continue;
                    }
                    if (parts[1].equals("thread") && parts[2].equals("ThreadCount")) {
                        QueryResult new_result = new QueryResult(myname, pidHost, myval, epochInMillis);
                        jvm_thread_counters.add(new_result);
                        continue;
                    }
                    if (parts[1].equals("gc") && (parts[2].equals("Copy") || parts[2].equals("MarkSweepCompact")) && (parts[3].equals("CollectionCount") || parts[3].equals("CollectionTime"))) {
                        QueryResult new_result = new QueryResult(myname, pidHost, myval, epochInMillis);
                        jvm_gc_counters.add(new_result);
                        continue;
                    }
                    if (!parts[1].equals("memorypool")) continue;
                    if ((parts[2].equals("Perm_Gen") || parts[2].equals("Code_Cache")) && (parts[4].equals("committed") || parts[4].equals("used"))) {
                        myname = "jvmNonHeapMemoryUsage";
                        String fullID = pidHost + "." + parts[2] + "." + parts[4];
                        float fval = Float.parseFloat(valstr);
                        try {
                            fval /= 1048576.0f;
                        }
                        catch (Exception e) {
                            this.exceptionCounter.incrementAndGet();
                            this.logger.warn("Exception doing Float: ", (Throwable)e);
                        }
                        QueryResult new_result = new QueryResult(myname, fullID, Float.valueOf(fval), epochInMillis);
                        nonheap_counters.add(new_result);
                        continue;
                    }
                    if (!parts[2].equals("Eden_Space") && !parts[2].equals("Survivor_Space") && !parts[2].equals("Tenured_Gen") || !parts[4].equals("committed") && !parts[4].equals("used")) continue;
                    myname = "jvmHeapMemoryUsage";
                    String fullID = pidHost + "." + parts[2] + "." + parts[4];
                    float fval = Float.parseFloat(valstr);
                    try {
                        fval /= 1048576.0f;
                    }
                    catch (Exception e) {
                        this.exceptionCounter.incrementAndGet();
                        this.logger.warn("Exception doingFloat: ", (Throwable)e);
                    }
                    QueryResult new_result = new QueryResult(myname, fullID, Float.valueOf(fval), epochInMillis);
                    heap_counters.add(new_result);
                    continue;
                }
                if (p1.equals("tomcat")) {
                    QueryResult new_result;
                    if (parts[1].equals("thread-pool") && (parts[3].equals("currentThreadsBusy") || parts[3].equals("currentThreadCount"))) {
                        String connector = parts[2];
                        myname = parts[0] + "." + parts[1] + "." + parts[3];
                        String fullID = pidHost + "." + connector;
                        QueryResult new_result2 = new QueryResult(myname, fullID, myval, epochInMillis);
                        tomcat_thread_pool_counters.add(new_result2);
                        continue;
                    }
                    if (parts[1].equals("global-request-processor")) {
                        String connector = parts[2];
                        myname = parts[0] + "." + parts[1] + "." + parts[3];
                        String fullID = pidHost + "." + connector;
                        if (parts[3].equals("processingTime")) {
                            float fval = Float.parseFloat(valstr);
                            try {
                                fval /= 1024.0f;
                            }
                            catch (Exception e) {
                                this.exceptionCounter.incrementAndGet();
                                this.logger.warn("Exception doingFloat: ", (Throwable)e);
                            }
                            new_result = new QueryResult(myname, fullID, Float.valueOf(fval), epochInMillis);
                            tomcat_grp_counters.add(new_result);
                            continue;
                        }
                        QueryResult new_result3 = new QueryResult(myname, fullID, myval, epochInMillis);
                        tomcat_grp_counters.add(new_result3);
                        continue;
                    }
                    if (parts[1].equals("manager") && parts[4].equals("activeSessions")) {
                        String myhost = parts[2];
                        String mycontext = parts[3];
                        myname = parts[0] + "." + parts[1] + "." + parts[4];
                        String fullID = pidHost + "." + myhost + "." + mycontext;
                        new_result = new QueryResult(myname, fullID, myval, epochInMillis);
                        tomcat_manager_counters.add(new_result);
                        continue;
                    }
                    if (parts[1].equals("servlet") && (parts[4].equals("processingTime") || parts[4].equals("errorCount") || parts[4].equals("requestCount"))) {
                        String myWebmodule = parts[2];
                        String myServletname = parts[3];
                        myname = parts[0] + "." + parts[1] + "." + parts[4];
                        String fullID = pidHost + "." + myWebmodule + "." + myServletname;
                        new_result = new QueryResult(myname, fullID, myval, epochInMillis);
                        tomcat_servlet_counters.add(new_result);
                        continue;
                    }
                    if (this.tomcat_db_groupID == null || !parts[1].equals("data-source")) continue;
                    String myhost = parts[2];
                    String mycontext = parts[3];
                    String mydbname = parts[4];
                    myname = parts[0] + "." + parts[1] + "." + parts[5];
                    String fullID = pidHost + "." + myhost + "." + mycontext + "." + mydbname;
                    QueryResult new_result4 = new QueryResult(myname, fullID, myval, epochInMillis);
                    tomcat_db_counters.add(new_result4);
                    continue;
                }
                if (this.app_groupID != null && p1.equals("cocktail")) {
                    if (parts[1].equals("CreatedCocktailCount") || parts[1].equals("UpdatedCocktailCount")) continue;
                    QueryResult new_result = new QueryResult(myname, pidHost, myval, epochInMillis);
                    app_counters.add(new_result);
                    continue;
                }
                if (this.app_sales_groupID == null || !p1.equals("sales") || !parts[1].equals("ordersCounter") && !parts[1].equals("itemsCounter") && !parts[1].equals("revenueInCentsCounter")) continue;
                QueryResult new_result = new QueryResult(myname, pidHost, myval, epochInMillis);
                app_sales_counters.add(new_result);
                continue;
            }
            this.logger.warn("parts return NULL!!!");
        }
        if (!jvm_os_counters.isEmpty()) {
            this.sort_n_send(this.jvm_os_groupID, jvm_os_counters);
        }
        if (!jvm_gc_counters.isEmpty()) {
            this.sort_n_send(this.jvm_gc_groupID, jvm_gc_counters);
        }
        if (!jvm_runtime_counters.isEmpty()) {
            this.sort_n_send(this.jvm_runtime_groupID, jvm_runtime_counters);
        }
        if (!jvm_class_counters.isEmpty()) {
            this.sort_n_send(this.jvm_class_groupID, jvm_class_counters);
        }
        if (!jvm_thread_counters.isEmpty()) {
            this.sort_n_send(this.jvm_thread_groupID, jvm_thread_counters);
        }
        if (!heap_counters.isEmpty()) {
            this.sort_n_send(this.heap_metric_groupID, heap_counters);
        }
        if (!nonheap_counters.isEmpty()) {
            this.sort_n_send(this.nonheap_metric_groupID, nonheap_counters);
        }
        if (!tomcat_thread_pool_counters.isEmpty()) {
            this.sort_n_send(this.tomcat_thread_pool_groupID, tomcat_thread_pool_counters);
        }
        if (!tomcat_grp_counters.isEmpty()) {
            this.sort_n_send(this.tomcat_grp_groupID, tomcat_grp_counters);
        }
        if (!tomcat_servlet_counters.isEmpty()) {
            this.sort_n_send(this.tomcat_servlet_groupID, tomcat_servlet_counters);
        }
        if (!tomcat_manager_counters.isEmpty()) {
            this.sort_n_send(this.tomcat_manager_groupID, tomcat_manager_counters);
        }
        if (!tomcat_db_counters.isEmpty()) {
            this.sort_n_send(this.tomcat_db_groupID, tomcat_db_counters);
        }
        if (!jmxtrans_counters.isEmpty()) {
            this.sort_n_send(this.jmxtrans_metric_groupID, jmxtrans_counters);
        }
        if (!app_counters.isEmpty()) {
            this.sort_n_send(this.app_groupID, app_counters);
        }
        if (!app_sales_counters.isEmpty()) {
            this.sort_n_send(this.app_sales_groupID, app_sales_counters);
        }
    }

    public void sort_n_send(String mg_name, List<QueryResult> mg_counters) {
        Collections.sort(mg_counters, new Comparator<QueryResult>(){

            @Override
            public int compare(QueryResult o1, QueryResult o2) {
                Integer rslt = o1.getEpochInMillis() < o2.getEpochInMillis() ? -1 : (o1.getEpochInMillis() > o2.getEpochInMillis() ? 1 : 0);
                if (rslt == 0) {
                    rslt = o1.getType().compareTo(o2.getType());
                }
                return rslt;
            }
        });
        this.send_metrics(mg_name, mg_counters);
    }

    public void send_metrics(String mg_name, List<QueryResult> counters) {
        long timeblock = counters.get(0).getEpoch(TimeUnit.SECONDS);
        String identifier = counters.get(0).getType();
        int remaining = counters.size();
        ArrayList<QueryResult> sorted_ctrs = new ArrayList<QueryResult>();
        for (QueryResult counter : counters) {
            --remaining;
            if (timeblock != counter.getEpoch(TimeUnit.SECONDS) || !identifier.equals(counter.getType())) {
                this.one_set(mg_name, sorted_ctrs);
                timeblock = counter.getEpoch(TimeUnit.SECONDS);
                identifier = counter.getType();
                sorted_ctrs.clear();
                sorted_ctrs.add(counter);
            } else {
                sorted_ctrs.add(counter);
            }
            if (remaining != 0) continue;
            this.one_set(mg_name, sorted_ctrs);
        }
    }

    public void one_set(String mg_name, List<QueryResult> counters) {
        HttpURLConnection urlCxn = null;
        URL newurl = null;
        try {
            newurl = new URL(this.url_str + "/samples/" + mg_name + ".json");
            urlCxn = this.proxy == null ? (HttpURLConnection)newurl.openConnection() : (HttpURLConnection)newurl.openConnection(this.proxy);
            if (urlCxn != null) {
                urlCxn.setRequestMethod("POST");
                urlCxn.setDoInput(true);
                urlCxn.setDoOutput(true);
                urlCxn.setReadTimeout(this.coppereggApiTimeoutInMillis);
                urlCxn.setRequestProperty("content-type", "application/json; charset=utf-8");
                urlCxn.setRequestProperty("Authorization", "Basic " + this.basicAuthentication);
            }
        }
        catch (Exception e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("Exception: one_set: failed to connect to CopperEgg Service '{}' with proxy {}", new Object[]{newurl, this.proxy, e});
            return;
        }
        if (urlCxn != null) {
            try {
                this.cue_serialize(counters, urlCxn.getOutputStream());
                int responseCode = urlCxn.getResponseCode();
                if (responseCode != 200) {
                    this.logger.warn("one_set: Failure {}: {} to send result to CopperEgg service {}", new Object[]{responseCode, urlCxn.getResponseMessage(), newurl});
                }
                try {
                    InputStream in = urlCxn.getInputStream();
                    IoUtils2.copy(in, IoUtils2.nullOutputStream());
                    IoUtils2.closeQuietly(in);
                    InputStream err = urlCxn.getErrorStream();
                    if (err != null) {
                        IoUtils2.copy(err, IoUtils2.nullOutputStream());
                        IoUtils2.closeQuietly(err);
                    }
                }
                catch (IOException e) {
                    this.exceptionCounter.incrementAndGet();
                    this.logger.warn("Execption one_set: Write-Exception flushing http connection", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.exceptionCounter.incrementAndGet();
                this.logger.warn("Execption: one_set: Failure to send result to CopperEgg Service '{}' with proxy {}", new Object[]{newurl, this.proxy, e});
            }
        }
    }

    public void cue_serialize(@Nonnull Iterable<QueryResult> counters, @Nonnull OutputStream out) throws IOException {
        boolean first = false;
        long time = 0L;
        String myID = null;
        JsonGenerator g = this.jsonFactory.createGenerator(out, JsonEncoding.UTF8);
        for (QueryResult counter : counters) {
            if (!first) {
                time = counter.getEpoch(TimeUnit.SECONDS);
                myID = counter.getType();
                first = true;
                g.writeStartObject();
                g.writeStringField("identifier", myID);
                g.writeNumberField("timestamp", time);
                g.writeObjectFieldStart("values");
            }
            if (counter.getValue() instanceof Integer) {
                g.writeNumberField(counter.getName(), ((Integer)counter.getValue()).intValue());
                continue;
            }
            if (counter.getValue() instanceof Long) {
                g.writeNumberField(counter.getName(), ((Long)counter.getValue()).longValue());
                continue;
            }
            if (counter.getValue() instanceof Float) {
                g.writeNumberField(counter.getName(), ((Float)counter.getValue()).floatValue());
                continue;
            }
            if (!(counter.getValue() instanceof Double)) continue;
            g.writeNumberField(counter.getName(), ((Double)counter.getValue()).doubleValue());
        }
        g.writeEndObject();
        g.writeEndObject();
        g.flush();
        g.close();
    }

    private static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public int cue_getExceptionCounter() {
        return this.exceptionCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensure_metric_groups() {
        URLConnection urlConnection = null;
        Object wr = null;
        URL myurl = null;
        try {
            myurl = new URL(this.url_str + "/metric_groups.json?show_hidden=1");
            urlConnection = (HttpURLConnection)myurl.openConnection();
            ((HttpURLConnection)urlConnection).setRequestMethod("GET");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.coppereggApiTimeoutInMillis);
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("Authorization", "Basic " + this.basicAuthentication);
            int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
            if (responseCode != 200) {
                this.logger.warn("Bad responsecode " + String.valueOf(responseCode) + " from metric_groups Index: " + myurl);
            }
        }
        catch (Exception e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("Failure to execute metric_groups index request " + myurl + "  " + e);
        }
        finally {
            if (urlConnection != null) {
                try {
                    InputStream in = urlConnection.getInputStream();
                    String theString = this.convertStreamToString(in);
                    for (Map.Entry<String, String> entry : metricgroupMap.entrySet()) {
                        String checkName = entry.getKey();
                        try {
                            String Rslt = this.groupFind(checkName, theString, 0);
                            if ((Rslt = Rslt != null ? this.Send_Commmand("/metric_groups/" + Rslt + ".json?show_hidden=1", "PUT", entry.getValue(), 0) : this.Send_Commmand("/metric_groups.json", "POST", entry.getValue(), 0)) == null) continue;
                            if (Rslt.toLowerCase().contains("tomcat")) {
                                if (Rslt.toLowerCase().contains("thread_pool")) {
                                    this.tomcat_thread_pool_groupID = Rslt;
                                    continue;
                                }
                                if (Rslt.toLowerCase().contains("grp")) {
                                    this.tomcat_grp_groupID = Rslt;
                                    continue;
                                }
                                if (Rslt.toLowerCase().contains("servlet")) {
                                    this.tomcat_servlet_groupID = Rslt;
                                    continue;
                                }
                                if (Rslt.toLowerCase().contains("manager")) {
                                    this.tomcat_manager_groupID = Rslt;
                                    continue;
                                }
                                if (!Rslt.toLowerCase().contains("db")) continue;
                                this.tomcat_db_groupID = Rslt;
                                continue;
                            }
                            if (Rslt.toLowerCase().contains("jmxtrans")) {
                                this.jmxtrans_metric_groupID = Rslt;
                                continue;
                            }
                            if (Rslt.toLowerCase().contains("sales")) {
                                this.app_sales_groupID = Rslt;
                                continue;
                            }
                            if (Rslt.toLowerCase().contains("cocktail")) {
                                this.app_groupID = Rslt;
                                continue;
                            }
                            if (Rslt.toLowerCase().contains("jvm")) {
                                if (Rslt.toLowerCase().contains("os")) {
                                    this.jvm_os_groupID = Rslt;
                                    continue;
                                }
                                if (Rslt.toLowerCase().contains("gc")) {
                                    this.jvm_gc_groupID = Rslt;
                                    continue;
                                }
                                if (Rslt.toLowerCase().contains("runtime")) {
                                    this.jvm_runtime_groupID = Rslt;
                                    continue;
                                }
                                if (Rslt.toLowerCase().contains("class")) {
                                    this.jvm_class_groupID = Rslt;
                                    continue;
                                }
                                if (!Rslt.toLowerCase().contains("thread")) continue;
                                this.jvm_thread_groupID = Rslt;
                                continue;
                            }
                            if (Rslt.toLowerCase().contains("nonheap")) {
                                this.nonheap_metric_groupID = Rslt;
                                continue;
                            }
                            if (!Rslt.toLowerCase().contains("heap")) continue;
                            this.heap_metric_groupID = Rslt;
                        }
                        catch (Exception e) {
                            this.exceptionCounter.incrementAndGet();
                            this.logger.warn("Exception in metric_group update or create: " + myurl + "  " + e);
                        }
                    }
                }
                catch (IOException e) {
                    this.exceptionCounter.incrementAndGet();
                    this.logger.warn("Exception flushing http connection" + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensure_dashboards() {
        URLConnection urlConnection = null;
        Object wr = null;
        URL myurl = null;
        try {
            myurl = new URL(this.url_str + "/dashboards.json");
            urlConnection = (HttpURLConnection)myurl.openConnection();
            ((HttpURLConnection)urlConnection).setRequestMethod("GET");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.coppereggApiTimeoutInMillis);
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("Authorization", "Basic " + this.basicAuthentication);
            int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
            if (responseCode != 200) {
                this.logger.warn("Bad responsecode " + String.valueOf(responseCode) + " from Dahsboards Index: " + myurl);
            }
        }
        catch (Exception e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("Exception on dashboards index request " + myurl + "  " + e);
        }
        finally {
            if (urlConnection != null) {
                try {
                    InputStream in = urlConnection.getInputStream();
                    String theString = this.convertStreamToString(in);
                    for (Map.Entry<String, String> entry : dashMap.entrySet()) {
                        String checkName = entry.getKey();
                        try {
                            String Rslt = this.groupFind(checkName, theString, 1);
                            if (Rslt != null) {
                                Rslt = this.Send_Commmand("/dashboards/" + Rslt + ".json", "PUT", entry.getValue(), 1);
                                continue;
                            }
                            Rslt = this.Send_Commmand("/dashboards.json", "POST", entry.getValue(), 1);
                        }
                        catch (Exception e) {
                            this.exceptionCounter.incrementAndGet();
                            this.logger.warn("Exception in dashboard update or create: " + myurl + "  " + e);
                        }
                    }
                }
                catch (IOException e) {
                    this.exceptionCounter.incrementAndGet();
                    this.logger.warn("Exception flushing http connection" + e);
                }
            }
        }
    }

    private String jparse(String jsonstr, Integer ExpectInt) {
        ObjectMapper mapper = new ObjectMapper();
        String Result = null;
        try {
            JsonNode root = mapper.readTree(jsonstr);
            if (ExpectInt != 0) {
                int myid = root.get("id").asInt();
                Result = String.valueOf(myid);
            } else {
                Result = root.get("id").asText().toString();
            }
        }
        catch (JsonGenerationException e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("JsonGenerationException " + (Object)((Object)e));
        }
        catch (JsonMappingException e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("JsonMappingException " + (Object)((Object)e));
        }
        catch (IOException e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("IOException " + e);
        }
        return Result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read_config(InputStream in) throws Exception {
        MappingJsonFactory f = new MappingJsonFactory();
        JsonParser jp = f.createJsonParser(in);
        JsonToken current = jp.nextToken();
        if (current != JsonToken.START_OBJECT) {
            this.logger.warn("read_config: Error:  START_OBJECT not found : quiting.");
            return;
        }
        current = jp.nextToken();
        String fieldName = jp.getCurrentName();
        current = jp.nextToken();
        if (!fieldName.equals("config")) return;
        if (current != JsonToken.START_OBJECT) {
            this.logger.warn("read_config: Error:  START_OBJECT not found after config : quiting.");
            return;
        }
        current = jp.nextToken();
        String fieldName2 = jp.getCurrentName();
        if (fieldName2.equals("metric_groups")) {
            current = jp.nextToken();
            if (current != JsonToken.START_ARRAY) {
                this.logger.warn("read_config: Error:  START_ARRAY not found after metric_groups : quiting.");
                return;
            }
            current = jp.nextToken();
            while (current != JsonToken.END_ARRAY) {
                if (current != JsonToken.START_OBJECT) {
                    this.logger.warn("read_config: Error:  START_OBJECT not found after metric_groups START_ARRAY : quiting.");
                    return;
                }
                current = jp.nextToken();
                JsonNode node1 = (JsonNode)jp.readValueAsTree();
                String node1string = this.write_tostring(node1);
                metricgroupMap.put(node1.get("name").asText(), node1string);
                current = jp.nextToken();
            }
            current = jp.nextToken();
            String fieldName3 = jp.getCurrentName();
            if (fieldName3.equals("dashboards")) {
                current = jp.nextToken();
                if (current != JsonToken.START_ARRAY) {
                    this.logger.warn("read_config: Error:  START_ARRAY not found after dashboards : quiting.");
                    return;
                }
                current = jp.nextToken();
                while (current != JsonToken.END_ARRAY) {
                    if (current != JsonToken.START_OBJECT) {
                        this.logger.warn("read_config: Error:  START_OBJECT not found after dashboards START_ARRAY : quiting.");
                        return;
                    }
                    current = jp.nextToken();
                    JsonNode node = (JsonNode)jp.readValueAsTree();
                    String nodestring = this.write_tostring(node);
                    dashMap.put(node.get("name").asText(), nodestring);
                    current = jp.nextToken();
                }
                if (jp.nextToken() != JsonToken.END_OBJECT) {
                    this.logger.warn("read_config: Error:  END_OBJECT expected, not found (1): quiting.");
                    return;
                }
                if (jp.nextToken() == JsonToken.END_OBJECT) return;
                this.logger.warn("read_config: Error:  END_OBJECT expected, not found (2): quiting.");
                return;
            }
            this.logger.warn("read_config: Error:  Expected dashboards : quiting.");
            return;
        }
        this.logger.warn("read_config: Error:  Expected metric_groups : quiting.");
    }

    public String groupFind(String findName, String findIndex, Integer ExpectInt) throws Exception {
        MappingJsonFactory f = new MappingJsonFactory();
        JsonParser jp = f.createJsonParser(findIndex);
        int count = 0;
        int foundit = 0;
        String Result = null;
        JsonToken current = jp.nextToken();
        if (current != JsonToken.START_ARRAY) {
            this.logger.warn("groupFind: Error: START_ARRAY expected, not found : quiting.");
            return Result;
        }
        current = jp.nextToken();
        while (current != JsonToken.END_ARRAY) {
            if (current != JsonToken.START_OBJECT) {
                this.logger.warn("groupFind: Error: START_OBJECT expected, not found : quiting.");
                return Result;
            }
            current = jp.nextToken();
            JsonNode node = (JsonNode)jp.readValueAsTree();
            String tmpStr = node.get("name").asText().toString();
            if (findName.equals(node.get("name").asText().toString())) {
                if (ExpectInt != 0) {
                    foundit = node.get("id").asInt();
                    Result = String.valueOf(foundit);
                    break;
                }
                Result = node.get("id").asText().toString();
                break;
            }
            current = jp.nextToken();
            ++count;
        }
        return Result;
    }

    public String write_tostring(JsonNode json) {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter out = new StringWriter();
        try {
            JsonFactory fac = new JsonFactory();
            JsonGenerator gen = fac.createJsonGenerator((Writer)out);
            mapper.writeTree(gen, json);
            gen.flush();
            gen.close();
            return out.toString();
        }
        catch (Exception e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("Exception in write_tostring: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String Send_Commmand(String command, String msgtype, String payload, Integer ExpectInt) {
        HttpURLConnection urlConnection = null;
        URL myurl = null;
        OutputStreamWriter wr = null;
        int responseCode = 0;
        String id = null;
        int error = 0;
        try {
            myurl = new URL(this.url_str + command);
            urlConnection = (HttpURLConnection)myurl.openConnection();
            urlConnection.setRequestMethod(msgtype);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.coppereggApiTimeoutInMillis);
            urlConnection.addRequestProperty("User-Agent", "Mozilla/4.76");
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("Authorization", "Basic " + this.basicAuthentication);
            wr = new OutputStreamWriter(urlConnection.getOutputStream(), "UTF-8");
            wr.write(payload);
            wr.flush();
            responseCode = urlConnection.getResponseCode();
            if (responseCode != 200) {
                this.logger.warn("Send Command: Response code " + responseCode + " url is " + myurl + " command " + msgtype);
                error = 1;
            }
        }
        catch (Exception e) {
            this.exceptionCounter.incrementAndGet();
            this.logger.warn("Exception in Send Command: url is " + myurl + " command " + msgtype + "; " + e);
            error = 1;
        }
        finally {
            if (urlConnection != null) {
                try {
                    if (error > 0) {
                        InputStream err = urlConnection.getErrorStream();
                        String errString = this.convertStreamToString(err);
                        this.logger.warn("Reported error : " + errString);
                        IoUtils2.closeQuietly(err);
                    } else {
                        InputStream in = urlConnection.getInputStream();
                        String theString = this.convertStreamToString(in);
                        id = this.jparse(theString, ExpectInt);
                        IoUtils2.closeQuietly(in);
                    }
                }
                catch (IOException e) {
                    this.exceptionCounter.incrementAndGet();
                    this.logger.warn("Exception in Send Command : flushing http connection " + e);
                }
            }
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    this.exceptionCounter.incrementAndGet();
                    this.logger.warn("Exception in Send Command: closing OutputWriter " + e);
                }
            }
        }
        return id;
    }
}

