/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CallingFormat;
import com.amazon.s3.GetResponse;
import com.amazon.s3.ListAllMyBucketsResponse;
import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.LocationResponse;
import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * Exception performing whole class analysis ignored.
 */
public class AWSAuthConnection {
    public static final String LOCATION_DEFAULT = null;
    public static final String LOCATION_EU = "EU";
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private CallingFormat callingFormat;

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, true);
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, port, CallingFormat.getSubdomainCallingFormat());
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, CallingFormat format) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80, format);
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, CallingFormat format) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.callingFormat = format;
    }

    public Response createBucket(String bucket, Map headers) throws MalformedURLException, IOException {
        return this.createBucket(bucket, null, headers);
    }

    public Response createBucket(String bucket, String location, Map headers) throws MalformedURLException, IOException {
        String body;
        if (location == null) {
            body = null;
        } else if ("EU".equals(location)) {
            if (!this.callingFormat.supportsLocatedBuckets()) {
                throw new IllegalArgumentException("Creating location-constrained bucket with unsupported calling-format");
            }
            body = "<CreateBucketConstraint><LocationConstraint>" + location + "</LocationConstraint></CreateBucketConstraint>";
        } else {
            throw new IllegalArgumentException("Invalid Location: " + location);
        }
        if (!Utils.validateBucketName((String)bucket, (CallingFormat)this.callingFormat, (location != null ? 1 : 0) != 0)) {
            throw new IllegalArgumentException("Invalid Bucket Name: " + bucket);
        }
        HttpURLConnection request = this.makeRequest("PUT", bucket, "", null, headers);
        if (body != null) {
            request.setDoOutput(true);
            request.getOutputStream().write(body.getBytes("UTF-8"));
        }
        return new Response(request);
    }

    public boolean checkBucketExists(String bucket) throws MalformedURLException, IOException {
        HttpURLConnection response = this.makeRequest("HEAD", bucket, "", null, null);
        int httpCode = response.getResponseCode();
        return httpCode >= 200 && httpCode < 300;
    }

    public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, Map headers) throws MalformedURLException, IOException {
        return this.listBucket(bucket, prefix, marker, maxKeys, null, headers);
    }

    public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, String delimiter, Map headers) throws MalformedURLException, IOException {
        Map pathArgs = Utils.paramsForListOptions((String)prefix, (String)marker, (Integer)maxKeys, (String)delimiter);
        return new ListBucketResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
    }

    public Response deleteBucket(String bucket, Map headers) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("DELETE", bucket, "", null, headers));
    }

    public Response put(String bucket, String key, S3Object object, Map headers) throws MalformedURLException, IOException {
        HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode((String)key), null, headers, object);
        request.setDoOutput(true);
        request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
        return new Response(request);
    }

    public Response copy(String sourceBucket, String sourceKey, String destinationBucket, String destinationKey, Map headers) throws MalformedURLException, IOException {
        S3Object object = new S3Object(new byte[0], new HashMap());
        headers = headers == null ? new HashMap<String, List<String>>() : new HashMap(headers);
        headers.put("x-amz-copy-source", Arrays.asList(sourceBucket + "/" + sourceKey));
        headers.put("x-amz-metadata-directive", Arrays.asList("COPY"));
        return this.verifyCopy(this.put(destinationBucket, destinationKey, object, headers));
    }

    public Response copy(String sourceBucket, String sourceKey, String destinationBucket, String destinationKey, Map metadata, Map headers) throws MalformedURLException, IOException {
        S3Object object = new S3Object(new byte[0], metadata);
        headers = headers == null ? new HashMap<String, List<String>>() : new HashMap(headers);
        headers.put("x-amz-copy-source", Arrays.asList(sourceBucket + "/" + sourceKey));
        headers.put("x-amz-metadata-directive", Arrays.asList("REPLACE"));
        return this.verifyCopy(this.put(destinationBucket, destinationKey, object, headers));
    }

    private Response verifyCopy(Response response) throws IOException {
        if (response.connection.getResponseCode() < 400) {
            byte[] body = GetResponse.slurpInputStream((InputStream)response.connection.getInputStream());
            String message = new String(body);
            if (message.indexOf("<Error") != -1) {
                throw new IOException(message.substring(message.indexOf("<Error")));
            }
            if (message.indexOf("</CopyObjectResult>") == -1) {
                throw new IOException("Unexpected response: " + message);
            }
        }
        return response;
    }

    public GetResponse get(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode((String)key), null, headers));
    }

    public Response delete(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("DELETE", bucket, Utils.urlencode((String)key), null, headers));
    }

    public GetResponse getBucketRequestPayment(String bucket, Map headers) throws MalformedURLException, IOException {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("requestPayment", null);
        return new GetResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
    }

    public Response putBucketRequestPayment(String bucket, String requestPaymentXMLDoc, Map headers) throws MalformedURLException, IOException {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("requestPayment", null);
        S3Object object = new S3Object(requestPaymentXMLDoc.getBytes(), null);
        HttpURLConnection request = this.makeRequest("PUT", bucket, "", pathArgs, headers, object);
        request.setDoOutput(true);
        request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
        return new Response(request);
    }

    public GetResponse getBucketLogging(String bucket, Map headers) throws MalformedURLException, IOException {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("logging", null);
        return new GetResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
    }

    public Response putBucketLogging(String bucket, String loggingXMLDoc, Map headers) throws MalformedURLException, IOException {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("logging", null);
        S3Object object = new S3Object(loggingXMLDoc.getBytes(), null);
        HttpURLConnection request = this.makeRequest("PUT", bucket, "", pathArgs, headers, object);
        request.setDoOutput(true);
        request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
        return new Response(request);
    }

    public GetResponse getBucketACL(String bucket, Map headers) throws MalformedURLException, IOException {
        return this.getACL(bucket, "", headers);
    }

    public GetResponse getACL(String bucket, String key, Map headers) throws MalformedURLException, IOException {
        if (key == null) {
            key = "";
        }
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("acl", null);
        return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode((String)key), pathArgs, headers));
    }

    public Response putBucketACL(String bucket, String aclXMLDoc, Map headers) throws MalformedURLException, IOException {
        return this.putACL(bucket, "", aclXMLDoc, headers);
    }

    public Response putACL(String bucket, String key, String aclXMLDoc, Map headers) throws MalformedURLException, IOException {
        S3Object object = new S3Object(aclXMLDoc.getBytes(), null);
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("acl", null);
        HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode((String)key), pathArgs, headers, object);
        request.setDoOutput(true);
        request.getOutputStream().write(object.data == null ? new byte[]{} : object.data);
        return new Response(request);
    }

    public LocationResponse getBucketLocation(String bucket) throws MalformedURLException, IOException {
        HashMap<String, Object> pathArgs = new HashMap<String, Object>();
        pathArgs.put("location", null);
        return new LocationResponse(this.makeRequest("GET", bucket, "", pathArgs, null));
    }

    public ListAllMyBucketsResponse listAllMyBuckets(Map headers) throws MalformedURLException, IOException {
        return new ListAllMyBucketsResponse(this.makeRequest("GET", "", "", null, headers));
    }

    private HttpURLConnection makeRequest(String method, String bucketName, String key, Map pathArgs, Map headers) throws MalformedURLException, IOException {
        return this.makeRequest(method, bucketName, key, pathArgs, headers, null);
    }

    private HttpURLConnection makeRequest(String method, String bucket, String key, Map pathArgs, Map headers, S3Object object) throws MalformedURLException, IOException {
        CallingFormat callingFormat = Utils.getCallingFormatForBucket((CallingFormat)this.callingFormat, (String)bucket);
        if (this.isSecure && callingFormat != CallingFormat.getPathCallingFormat() && bucket.indexOf(".") != -1) {
            System.err.println("You are making an SSL connection, however, the bucket contains periods and the wildcard certificate will not match by default.  Please consider using HTTP.");
        }
        URL url = callingFormat.getURL(this.isSecure, this.server, this.port, bucket, key, pathArgs);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        if (!connection.getInstanceFollowRedirects() && callingFormat.supportsLocatedBuckets()) {
            throw new RuntimeException("HTTP redirect support required.");
        }
        this.addHeaders(connection, headers);
        if (object != null) {
            this.addMetadataHeaders(connection, object.metadata);
        }
        this.addAuthHeader(connection, method, bucket, key, pathArgs);
        return connection;
    }

    private void addHeaders(HttpURLConnection connection, Map headers) {
        this.addHeaders(connection, headers, "");
    }

    private void addMetadataHeaders(HttpURLConnection connection, Map metadata) {
        this.addHeaders(connection, metadata, "x-amz-meta-");
    }

    private void addHeaders(HttpURLConnection connection, Map headers, String prefix) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                for (String value : (List)headers.get(key)) {
                    connection.addRequestProperty(prefix + key, value);
                }
            }
        }
    }

    private void addAuthHeader(HttpURLConnection connection, String method, String bucket, String key, Map pathArgs) {
        if (connection.getRequestProperty("Date") == null) {
            connection.setRequestProperty("Date", AWSAuthConnection.httpDate());
        }
        if (connection.getRequestProperty("Content-Type") == null) {
            connection.setRequestProperty("Content-Type", "");
        }
        String canonicalString = Utils.makeCanonicalString((String)method, (String)bucket, (String)key, (Map)pathArgs, connection.getRequestProperties());
        String encodedCanonical = Utils.encode((String)this.awsSecretAccessKey, (String)canonicalString, (boolean)false);
        connection.setRequestProperty("Authorization", "AWS " + this.awsAccessKeyId + ":" + encodedCanonical);
    }

    public static String httpDate() {
        String DateFormat2 = "EEE, dd MMM yyyy HH:mm:ss ";
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(new Date()) + "GMT";
    }
}

