/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ListBucketResponse
extends Response {
    public String name = null;
    public String prefix = null;
    public String marker = null;
    public String delimiter = null;
    public int maxKeys = 0;
    public boolean isTruncated = false;
    public String nextMarker = null;
    public List entries = null;
    public List commonPrefixEntries = null;

    public ListBucketResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            try {
                XMLReader xr = Utils.createXMLReader();
                ListBucketHandler handler = new ListBucketHandler(this);
                xr.setContentHandler((ContentHandler)handler);
                xr.setErrorHandler((ErrorHandler)handler);
                xr.parse(new InputSource(connection.getInputStream()));
                this.name = handler.getName();
                this.prefix = handler.getPrefix();
                this.marker = handler.getMarker();
                this.delimiter = handler.getDelimiter();
                this.maxKeys = handler.getMaxKeys();
                this.isTruncated = handler.getIsTruncated();
                this.nextMarker = handler.getNextMarker();
                this.entries = handler.getKeyEntries();
                this.commonPrefixEntries = handler.getCommonPrefixEntries();
            }
            catch (SAXException e) {
                throw new RuntimeException("Unexpected error parsing ListBucket xml", e);
            }
        }
    }
}

