/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.LocationResponse;
import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LocationResponse
extends Response {
    String location;

    public LocationResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            try {
                XMLReader xr = Utils.createXMLReader();
                LocationResponseHandler handler = new LocationResponseHandler();
                xr.setContentHandler((ContentHandler)handler);
                xr.setErrorHandler((ErrorHandler)handler);
                xr.parse(new InputSource(connection.getInputStream()));
                this.location = handler.location;
            }
            catch (SAXException e) {
                throw new RuntimeException("Unexpected error parsing ListAllMyBuckets xml", e);
            }
        } else {
            this.location = "<error>";
        }
    }

    public String getLocation() {
        return this.location;
    }
}

