/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.cocktail;

import com.amazon.s3.AWSAuthConnection;
import com.amazon.s3.QueryStringAuthGenerator;
import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AmazonS3RestService {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonS3RestService.class);
    private Map<String, String> contentTypeByFileExtension;
    private Map<String, String> defaultFileExtensionByContentType;
    private final Random random = new Random();
    @Value(value="${aws_s3_bucket_base_url}")
    private String amazonS3BucketBaseUrl;
    @Value(value="${aws_s3_bucket_name}")
    private String amazonS3BucketName;
    private final AWSAuthConnection conn;
    private final QueryStringAuthGenerator generator;

    @Inject
    public AmazonS3RestService(@Value(value="${AWS_ACCESS_KEY_ID}") String awsAccessKey, @Value(value="${AWS_SECRET_KEY}") String awsSecretKey) {
        this.conn = new AWSAuthConnection(awsAccessKey, awsSecretKey);
        this.generator = new QueryStringAuthGenerator(awsAccessKey, awsSecretKey);
        this.contentTypeByFileExtension = Maps.newHashMapWithExpectedSize((int)4);
        this.contentTypeByFileExtension.put("jpg", "image/jpeg");
        this.contentTypeByFileExtension.put("jpeg", "image/jpeg");
        this.contentTypeByFileExtension.put("png", "image/png");
        this.contentTypeByFileExtension.put("gif", "image/gif");
        this.defaultFileExtensionByContentType = Maps.newHashMapWithExpectedSize((int)3);
        this.defaultFileExtensionByContentType.put("image/jpeg", "jpg");
        this.defaultFileExtensionByContentType.put("image/png", "png");
        this.defaultFileExtensionByContentType.put("image/gif", "gif");
    }

    @Nullable
    public String findContentType(String fileName) {
        String fileExtension = (String)Iterables.getLast((Iterable)Splitter.on((char)'.').split((CharSequence)fileName), null);
        fileExtension = Strings.nullToEmpty((String)fileExtension).toLowerCase();
        return (String)this.contentTypeByFileExtension.get(fileExtension);
    }

    @Nonnull
    public String storeFile(byte[] buffer, Map objectMetadata) {
        String extension = (String)this.defaultFileExtensionByContentType.get(objectMetadata.get("Content-Type"));
        String fileName = Math.abs(this.random.nextLong()) + "." + extension;
        S3Object object = new S3Object(buffer, objectMetadata);
        try {
            Response r = this.conn.put(this.amazonS3BucketName, fileName, object, objectMetadata);
            LOG.info(r.connection.getResponseMessage());
        }
        catch (IOException e) {
            LOG.error("Problem on put file to S3", (Throwable)e);
        }
        return this.amazonS3BucketBaseUrl + fileName;
    }
}

