/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.cocktail;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import fr.xebia.cocktail.Ingredient;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;

public class Cocktail
implements Comparable<Cocktail> {
    private List<Ingredient> ingredients = Lists.newArrayList();
    private String instructions;
    @Nonnull
    private String name;
    private String id;
    private String photoUrl;
    private String sourceUrl;
    private Deque<String> comments = Lists.newLinkedList();

    @Override
    public int compareTo(Cocktail other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.name), (Comparable)((Object)other.name)).result();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cocktail other = (Cocktail)obj;
        return Objects.equal((Object)this.id, (Object)other.id);
    }

    public Deque<String> getComments() {
        return this.comments;
    }

    public String getId() {
        return this.id;
    }

    public Collection<String> getIngredientNames() {
        return Collections2.transform((Collection)this.ingredients, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public String getInstructionsAsHtml() {
        return Strings.nullToEmpty((String)this.instructions).replace("\n", "<br />\n");
    }

    public String getName() {
        return this.name;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public void setComments(Deque<String> comments) {
        this.comments = comments;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIngredients(List<Ingredient> ingredients) {
        this.ingredients = ingredients;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).toString();
    }

    public Cocktail addComment(String comment) {
        this.getComments().addFirst(comment);
        return this;
    }

    public Cocktail withId(String id) {
        this.setId(id);
        return this;
    }

    public Cocktail withIngredient(String quantity, String name) {
        this.ingredients.add(new Ingredient(quantity, name));
        return this;
    }

    public Cocktail withInstructions(String instructions) {
        this.setInstructions(instructions);
        return this;
    }

    public Cocktail withName(String name) {
        this.setName(name);
        return this;
    }

    public Cocktail withPhotoUrl(String photoUrl) {
        this.setPhotoUrl(photoUrl);
        return this;
    }

    public Cocktail withSourceUrl(String sourceUrl) {
        this.setSourceUrl(sourceUrl);
        return this;
    }
}

