/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.cocktail;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fr.xebia.cocktail.AmazonS3RestService;
import fr.xebia.cocktail.Cocktail;
import fr.xebia.cocktail.CocktailRepository;
import fr.xebia.cocktail.CocktailRssView;
import fr.xebia.cocktail.ResourceNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@ManagedResource(value="cocktail:type=CocktailManager,name=CocktailManager")
@Controller
public class CocktailManager {
    @Inject
    private CocktailRepository cocktailRepository;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private AmazonS3RestService fileStorageService;
    private final AtomicInteger addedCommentCount = new AtomicInteger();

    @RequestMapping(value={"/cocktail/{id}/comment"}, method={RequestMethod.POST})
    public String addComment(@PathVariable String id, @RequestParam(value="comment") String comment, HttpServletRequest request) {
        Cocktail cocktail = this.cocktailRepository.get(id);
        if (cocktail == null) {
            throw new ResourceNotFoundException(id);
        }
        this.logger.debug("Add comment: '{}' to {}", (Object)comment, (Object)cocktail);
        cocktail.getComments().addFirst(comment);
        this.cocktailRepository.update(cocktail);
        this.addedCommentCount.incrementAndGet();
        return "redirect:/cocktail/{id}";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/cocktail"})
    public String create(Cocktail cocktail, BindingResult result) {
        if (result.hasErrors()) {
            return "cocktail/create-form";
        }
        this.cocktailRepository.insert(cocktail);
        return "redirect:/cocktail/" + cocktail.getId();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail/create-form"})
    public String displayCreateForm(Model model) {
        model.addAttribute((Object)new Cocktail());
        return "cocktail/create-form";
    }

    @RequestMapping(value={"/cocktail/{id}/edit-form"}, method={RequestMethod.GET})
    public String displayEditForm(@PathVariable String id, Model model) {
        Cocktail cocktail = this.cocktailRepository.get(id);
        if (cocktail == null) {
            throw new ResourceNotFoundException(id);
        }
        model.addAttribute((Object)cocktail);
        return "cocktail/edit-form";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail/suggest/ingredient"})
    @ResponseBody
    public List<String> suggestCocktailIngredientWord(@RequestParam(value="term") String term) {
        List words = this.cocktailRepository.suggestCocktailIngredientWords(term);
        this.logger.trace("autocomplete word for {}:{}", (Object)term, (Object)words);
        return words;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail/suggest/name"})
    @ResponseBody
    public List<String> suggestCocktailNameWord(@RequestParam(value="term") String term) {
        List words = this.cocktailRepository.suggestCocktailNameWords(term);
        this.logger.trace("autocomplete word for {}:{}", (Object)term, (Object)words);
        return words;
    }

    @RequestMapping(value={"/cocktail/{id}"}, method={RequestMethod.PUT})
    public String update(@PathVariable String id, Cocktail cocktail, BindingResult result) {
        if (result.hasErrors()) {
            return "redirect:/cocktail/{id}/edit";
        }
        cocktail.setId(id);
        Collection ingredients = Collections2.filter((Collection)cocktail.getIngredients(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        cocktail.setIngredients((List)Lists.newArrayList((Iterable)ingredients));
        this.cocktailRepository.update(cocktail);
        return "redirect:/cocktail/{id}";
    }

    @RequestMapping(value={"/cocktail/{id}/photo"}, method={RequestMethod.POST})
    public String updatePhoto(@PathVariable String id, @RequestParam(value="photo") MultipartFile photo) {
        if (!photo.isEmpty()) {
            try {
                String contentType = this.fileStorageService.findContentType(photo.getOriginalFilename());
                if (contentType == null) {
                    this.logger.warn("photo", (Object)("Skip file with unsupported extension '" + photo.getOriginalFilename() + "'"));
                } else {
                    InputStream photoInputStream = photo.getInputStream();
                    long photoSize = photo.getSize();
                    TreeMap<String, List<String>> metadata = new TreeMap<String, List<String>>();
                    metadata.put("Content-Length", Arrays.asList("" + photoSize));
                    metadata.put("Content-Type", Arrays.asList(contentType));
                    metadata.put("Cache-Control", Arrays.asList("public, max-age=" + TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS)));
                    String photoUrl = this.fileStorageService.storeFile(photo.getBytes(), metadata);
                    Cocktail cocktail = this.cocktailRepository.get(id);
                    this.logger.info("Saved {}", (Object)photoUrl);
                    cocktail.setPhotoUrl(photoUrl);
                    this.cocktailRepository.update(cocktail);
                }
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return "redirect:/cocktail/" + id;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail/{id}"})
    public String view(@PathVariable String id, Model model) {
        Cocktail cocktail = this.cocktailRepository.get(id);
        if (cocktail == null) {
            throw new ResourceNotFoundException(id);
        }
        model.addAttribute((Object)cocktail);
        return "cocktail/view";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail"})
    public ModelAndView find(@RequestParam(value="name", required=false) String name, @RequestParam(value="ingredient", required=false) String ingredient) {
        Collection cocktails = this.cocktailRepository.find(ingredient, name);
        return new ModelAndView("cocktail/view-all", "cocktails", (Object)cocktails);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/rss"})
    public ModelAndView rss(HttpServletResponse response) {
        Collection cocktails = this.cocktailRepository.find(null, null);
        ModelAndView modelAndView = new ModelAndView((View)new CocktailRssView((Iterable)cocktails));
        long timeToLiveInSeconds = 300L;
        response.setDateHeader("Expires", System.currentTimeMillis() + timeToLiveInSeconds * 1000L);
        response.setHeader("Cache-Control", "public, max-age=" + timeToLiveInSeconds);
        return modelAndView;
    }

    @ManagedMetric(metricType=MetricType.COUNTER)
    public int getAddedCommentCount() {
        return this.addedCommentCount.get();
    }
}

