/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.cocktail;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fr.xebia.cocktail.Cocktail;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CocktailRepository {
    @VisibleForTesting
    protected Cache<String, Cocktail> cocktails;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CocktailRepository() {
        this.cocktails = CacheBuilder.newBuilder().maximumSize(100L).build();
        this.insert(this.buildLongIslandCocktail());
        this.insert(this.buildSexOnTheBeachCocktail());
    }

    public void delete(Cocktail cocktail) {
        Preconditions.checkNotNull((Object)cocktail.getId(), (String)"Given id must not be null in %s", (Object[])new Object[]{cocktail});
        this.cocktails.invalidate((Object)cocktail.getId());
    }

    public Collection<Cocktail> find(@Nullable String ingredient, @Nullable String name) {
        Object ingredientPredicate = Strings.isNullOrEmpty((String)ingredient) ? Predicates.alwaysTrue() : new /* Unavailable Anonymous Inner Class!! */;
        Object namePredicate = Strings.isNullOrEmpty((String)name) ? Predicates.alwaysTrue() : new /* Unavailable Anonymous Inner Class!! */;
        return Lists.newArrayList((Iterable)Collections2.filter(this.cocktails.asMap().values(), (Predicate)Predicates.and((Predicate)namePredicate, (Predicate)ingredientPredicate)));
    }

    public Cocktail get(String id) {
        return (Cocktail)this.cocktails.getIfPresent((Object)id);
    }

    public void insert(Cocktail cocktail) {
        Preconditions.checkArgument((cocktail.getId() == null ? 1 : 0) != 0, (String)"Given id must be null in %s", (Object[])new Object[]{cocktail});
        cocktail.setId(RandomStringUtils.randomAlphanumeric((int)5));
        this.cocktails.put((Object)cocktail.getId(), (Object)cocktail);
    }

    public void purgeRepository() {
        this.cocktails.invalidateAll();
    }

    public List<String> suggestCocktailIngredientWords(String query) {
        return Lists.newArrayList((Object[])new String[]{"#TODO#"});
    }

    public List<String> suggestCocktailNameWords(String query) {
        return Lists.newArrayList((Object[])new String[]{"#TODO#"});
    }

    public void update(Cocktail cocktail) {
        Preconditions.checkNotNull((Object)cocktail.getId(), (String)"Given objectId must not be null in %s", (Object[])new Object[]{cocktail});
        this.cocktails.put((Object)cocktail.getId(), (Object)cocktail);
    }

    protected Cocktail buildSexOnTheBeachCocktail() {
        Cocktail sexOnTheBeach = new Cocktail().withName("Sex On The Beach").withIngredient("1 shot", "vodka").withIngredient("1 shot", "peach schnapps (archers)").withIngredient("200 ml", "orange juice").withIngredient("200 ml", "cranberry juice").withIngredient("2 shots", "raspberry syrup").withPhotoUrl("http://xebia-cocktail.s3-website-us-east-1.amazonaws.com/4703755392347885371.jpg").withSourceUrl("http://www.cocktailmaking.co.uk/displaycocktail.php/321-Sex-On-The-Beach").withInstructions("Add ice to glass pour in shot of vodka add peach shnapps mix with orange, cranberry and raspberry\n\nServe with an umbrella and a mixer stick and a fancy straw and an orange slice on side of glass this one is gorgeous can't believe you don't already have it on here!");
        return sexOnTheBeach;
    }

    protected Cocktail buildLongIslandCocktail() {
        Cocktail longIslandIcedTea = new Cocktail().withName("Long Island Iced tea").withIngredient("1 Measure", "vodka").withIngredient("1 Measure", "gin").withIngredient("1 Measure", "white rum").withIngredient("1 Measure", "tequila").withIngredient("1 Measure", "triple sec").withIngredient("3 measures", "orange juice").withIngredient("to topp up the glass", "coke").withPhotoUrl("http://xebia-cocktail.s3-website-us-east-1.amazonaws.com/6762530443361434570.jpg").withSourceUrl("http://www.cocktailmaking.co.uk/displaycocktail.php/1069-Long-Island-Iced-tea").withInstructions("In a tall glass , add ice and all the ingredients and stir well. It should have the appearance of cloudy tea. Top with a piece of lemon\n\nVery yummy & very very deceiving. It will get you hammered after only about 2 so drink with caution");
        return longIslandIcedTea;
    }
}

