/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.samples.cocktail.cart;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.jmxtrans.embedded.samples.cocktail.cart.ShoppingCart;
import org.jmxtrans.embedded.samples.cocktail.cocktail.Cocktail;

public class ShoppingCart
implements Serializable {
    private SortedMap<Cocktail, ShoppingCartItem> items = new TreeMap();

    public void addItem(Cocktail cocktail, int quantity) {
        ShoppingCartItem item = (ShoppingCartItem)this.items.get(cocktail);
        if (item == null) {
            this.items.put(cocktail, new ShoppingCartItem(cocktail, quantity));
        } else {
            item.incrementQuantity(quantity);
        }
    }

    @Nonnull
    public Collection<ShoppingCartItem> getItems() {
        return this.items.values();
    }

    public int getPriceInCents() {
        int totalPriceInCents = 0;
        for (ShoppingCartItem item : this.getItems()) {
            totalPriceInCents += item.getTotalPriceInCents();
        }
        return totalPriceInCents;
    }

    public String getPrettyPrice() {
        BigDecimal priceInDollars = new BigDecimal(this.getPriceInCents()).movePointLeft(2);
        return NumberFormat.getCurrencyInstance(Locale.US).format(priceInDollars);
    }

    public int getItemsCount() {
        int itemsCount = 0;
        for (ShoppingCartItem item : this.getItems()) {
            itemsCount += item.getQuantity();
        }
        return itemsCount;
    }
}

