/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.samples.cocktail.cart;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.jmxtrans.embedded.samples.cocktail.cart.ShoppingCart;
import org.jmxtrans.embedded.samples.cocktail.cart.ShoppingCartRepository;
import org.jmxtrans.embedded.samples.cocktail.cocktail.Cocktail;
import org.jmxtrans.embedded.samples.cocktail.cocktail.CocktailRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@ManagedResource(value="cocktail:type=ShoppingCartController,name=ShoppingCartController")
@Controller
public class ShoppingCartController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AtomicInteger shoppingCartsPriceInCents = new AtomicInteger();
    protected final AtomicInteger salesRevenueInCentsCounter = new AtomicInteger();
    protected final AtomicInteger salesItemsCounter = new AtomicInteger();
    protected final AtomicInteger salesOrdersCounter = new AtomicInteger();
    @Autowired
    ShoppingCartRepository shoppingCartRepository;
    @Autowired
    private CocktailRepository cocktailRepository;

    @RequestMapping(method={RequestMethod.POST}, value={"/cart/add"})
    public String addItem(@RequestParam(value="cocktail") long cocktailId, @RequestParam(value="quantity", required=false, defaultValue="1") int quantity, HttpServletRequest request) {
        Cocktail cocktail = this.cocktailRepository.get(cocktailId);
        if (cocktail == null) {
            this.logger.warn("No cocktail found with id " + cocktailId + ". Silently redirect to home page");
            return "redirect:/";
        }
        ShoppingCart shoppingCart = this.shoppingCartRepository.getCurrentShoppingCart(request);
        this.shoppingCartsPriceInCents.addAndGet(quantity * cocktail.getPriceInCents());
        shoppingCart.addItem(cocktail, quantity);
        return "redirect:/cocktail/" + cocktailId;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cart/"})
    public String view(HttpServletRequest request) {
        return "cart/view";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/cart/buy"})
    public String buy(HttpServletRequest request) {
        ShoppingCart shoppingCart = this.shoppingCartRepository.getCurrentShoppingCart(request);
        this.salesRevenueInCentsCounter.addAndGet(shoppingCart.getPriceInCents());
        this.salesItemsCounter.addAndGet(shoppingCart.getItemsCount());
        this.salesOrdersCounter.incrementAndGet();
        this.shoppingCartRepository.resetCurrentShoppingCart(request);
        return "redirect:/";
    }

    @ManagedMetric
    public int getShoppingCartsPriceInCents() {
        return this.shoppingCartsPriceInCents.get();
    }

    @ManagedMetric
    public int getSalesRevenueInCentsCounter() {
        return this.salesRevenueInCentsCounter.get();
    }

    @ManagedMetric
    public int getSalesItemsCounter() {
        return this.salesItemsCounter.get();
    }

    @ManagedMetric
    public int getSalesOrdersCounter() {
        return this.salesOrdersCounter.get();
    }
}

