/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.samples.cocktail.cocktail;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jmxtrans.embedded.samples.cocktail.cocktail.Cocktail;

public class Cocktail
implements Comparable<Cocktail>,
Serializable {
    private List<Ingredient> ingredients = new ArrayList();
    private String instructions;
    private String name;
    private long id;
    private String photoUrl;
    private String recipeUrl;
    private Deque<String> comments = new LinkedList();
    private int priceInCents;

    public String getInstructionsAsHtml() {
        return this.instructions == null ? "" : this.instructions.replace("\n", "<br />\n");
    }

    public Collection<String> getIngredientNames() {
        ArrayList<String> ingredientNames = new ArrayList<String>();
        for (Ingredient ingredient : this.ingredients) {
            ingredientNames.add(ingredient.getName());
        }
        return ingredientNames;
    }

    @Override
    public int compareTo(Cocktail other) {
        if (this.name == null) {
            return other.name == null ? 0 : -1;
        }
        return this.name.compareTo(other.name);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<Ingredient> ingredients) {
        this.ingredients = ingredients;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public String getRecipeUrl() {
        return this.recipeUrl;
    }

    public void setRecipeUrl(String recipeUrl) {
        this.recipeUrl = recipeUrl;
    }

    public Deque<String> getComments() {
        return this.comments;
    }

    public void setComments(Deque<String> comments) {
        this.comments = comments;
    }

    public Cocktail withId(long id) {
        this.setId(id);
        return this;
    }

    public Cocktail withIngredient(String quantity, String name) {
        this.ingredients.add(new Ingredient(quantity, name));
        return this;
    }

    public Cocktail withInstructions(String instructions) {
        this.setInstructions(instructions);
        return this;
    }

    public Cocktail withName(String name) {
        this.setName(name);
        return this;
    }

    public Cocktail withPhotoUrl(String photoUrl) {
        this.setPhotoUrl(photoUrl);
        return this;
    }

    public Cocktail withRecipeUrl(String recipeUrl) {
        this.setRecipeUrl(recipeUrl);
        return this;
    }

    public int getPriceInCents() {
        return this.priceInCents;
    }

    public String getPrettyPrice() {
        BigDecimal priceInDollars = new BigDecimal(this.getPriceInCents()).movePointLeft(2);
        return NumberFormat.getCurrencyInstance(Locale.US).format(priceInDollars);
    }

    public void setPriceInCents(int priceInCents) {
        this.priceInCents = priceInCents;
    }

    public Cocktail withPriceInCents(int priceInCents) {
        this.priceInCents = priceInCents;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cocktail)) {
            return false;
        }
        Cocktail cocktail = (Cocktail)o;
        return this.id == cocktail.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

