/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.samples.cocktail.cocktail;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.jmxtrans.embedded.samples.cocktail.cocktail.Cocktail;
import org.jmxtrans.embedded.samples.cocktail.cocktail.CocktailController;
import org.jmxtrans.embedded.samples.cocktail.cocktail.CocktailRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@ManagedResource(value="cocktail:type=CocktailController,name=CocktailController")
@Controller
public class CocktailController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger addedCommentCount = new AtomicInteger();
    private final AtomicInteger displayedCocktailCount = new AtomicInteger();
    private final AtomicInteger createdCocktailCount = new AtomicInteger();
    private final AtomicInteger updatedCocktailCount = new AtomicInteger();
    private final AtomicInteger searchedCocktailCount = new AtomicInteger();
    private final AtomicInteger displayedHomeCount = new AtomicInteger();
    @Autowired
    private CocktailRepository cocktailRepository;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String home() {
        this.displayedHomeCount.incrementAndGet();
        return "welcome";
    }

    @RequestMapping(value={"/cocktail/{id}/comment"}, method={RequestMethod.POST})
    public String addComment(@PathVariable long id, @RequestParam(value="comment") String comment, HttpServletRequest request) {
        Cocktail cocktail = this.cocktailRepository.get(id);
        if (cocktail == null) {
            throw new CocktailNotFoundException(id);
        }
        this.logger.debug("Add comment: '{}' to {}", (Object)comment, (Object)cocktail);
        cocktail.getComments().addFirst(comment);
        this.cocktailRepository.update(cocktail);
        this.addedCommentCount.incrementAndGet();
        return "redirect:/cocktail/{id}";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail/suggest/ingredient"})
    @ResponseBody
    public List<String> suggestCocktailIngredientWord(@RequestParam(value="term") String term) {
        List words = this.cocktailRepository.suggestCocktailIngredientWords(term);
        this.logger.trace("autocomplete word for {}:{}", (Object)term, (Object)words);
        return words;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail/suggest/name"})
    @ResponseBody
    public List<String> suggestCocktailNameWord(@RequestParam(value="term") String term) {
        List words = this.cocktailRepository.suggestCocktailNameWords(term);
        this.logger.trace("autocomplete word for {}:{}", (Object)term, (Object)words);
        return words;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail/{id}"})
    public String view(@PathVariable long id, Model model) {
        Cocktail cocktail = this.cocktailRepository.get(id);
        if (cocktail == null) {
            throw new CocktailNotFoundException(id);
        }
        model.addAttribute((Object)cocktail);
        this.displayedCocktailCount.incrementAndGet();
        return "cocktail/view";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/cocktail"})
    public ModelAndView find(@RequestParam(value="name", required=false) String name, @RequestParam(value="ingredient", required=false) String ingredient) {
        Collection cocktails = this.cocktailRepository.find(ingredient, name);
        this.searchedCocktailCount.incrementAndGet();
        return new ModelAndView("cocktail/view-all", "cocktails", (Object)cocktails);
    }

    @ManagedMetric(metricType=MetricType.COUNTER)
    public int getAddedCommentCount() {
        return this.addedCommentCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER)
    public int getCreatedCocktailCount() {
        return this.createdCocktailCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER)
    public int getDisplayedCocktailCount() {
        return this.displayedCocktailCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER)
    public int getSearchedCocktailCount() {
        return this.searchedCocktailCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER)
    public int getUpdatedCocktailCount() {
        return this.updatedCocktailCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER)
    public int getDisplayedHomeCount() {
        return this.displayedHomeCount.get();
    }
}

