/*
 * Decompiled with CFR 0.152.
 */
package org.jmxtrans.embedded.samples.cocktail.cocktail;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.jmxtrans.embedded.samples.cocktail.cocktail.Cocktail;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CocktailRepository {
    private Map<Long, Cocktail> cocktails = new HashMap();
    private AtomicLong cocktailSequence = new AtomicLong();

    public CocktailRepository() {
        Cocktail sexOnTheBeach = this.buildSexOnTheBeachCocktail();
        this.cocktails.put(sexOnTheBeach.getId(), sexOnTheBeach);
        Cocktail longIslandIcedTea = this.buildLongIslandCocktail();
        this.cocktails.put(longIslandIcedTea.getId(), longIslandIcedTea);
    }

    public Collection<Cocktail> find(@Nullable String ingredientName, @Nullable String cocktailName) {
        TreeSet<Cocktail> result = new TreeSet<Cocktail>();
        block0: for (Cocktail cocktail : this.cocktails.values()) {
            if (cocktailName == null && ingredientName == null) {
                result.add(cocktail);
            }
            if (StringUtils.hasLength((String)cocktailName) && cocktail.getName().toLowerCase().contains(cocktailName.toLowerCase())) {
                result.add(cocktail);
                break;
            }
            if (ingredientName == null) continue;
            for (String cocktailIngredient : cocktail.getIngredientNames()) {
                if (!cocktailIngredient.toLowerCase().contains(ingredientName.toLowerCase())) continue;
                result.add(cocktail);
                continue block0;
            }
        }
        return result;
    }

    public Cocktail get(long id) {
        return (Cocktail)this.cocktails.get(id);
    }

    public List<String> suggestCocktailIngredientWords(String query) {
        return Collections.singletonList("#TODO#");
    }

    public List<String> suggestCocktailNameWords(String query) {
        return Collections.singletonList("#TODO#");
    }

    public void update(Cocktail cocktail) {
        this.cocktails.put(cocktail.getId(), cocktail);
    }

    protected Cocktail buildSexOnTheBeachCocktail() {
        Cocktail sexOnTheBeach = new Cocktail().withId(this.cocktailSequence.incrementAndGet()).withName("Sex On The Beach").withPriceInCents(550).withIngredient("1 shot", "vodka").withIngredient("1 shot", "peach schnapps (archers)").withIngredient("200 ml", "orange juice").withIngredient("200 ml", "cranberry juice").withIngredient("2 shots", "raspberry syrup").withPhotoUrl("http://xebia-cocktail.s3-website-us-east-1.amazonaws.com/4703755392347885371.jpg").withRecipeUrl("http://www.cocktailmaking.co.uk/displaycocktail.php/321-Sex-On-The-Beach").withInstructions("Add ice to glass pour in shot of vodka add peach shnapps mix with orange, cranberry and raspberry\n\nServe with an umbrella and a mixer stick and a fancy straw and an orange slice on side of glass this one is gorgeous can't believe you don't already have it on here!");
        return sexOnTheBeach;
    }

    protected Cocktail buildLongIslandCocktail() {
        Cocktail longIslandIcedTea = new Cocktail().withId(this.cocktailSequence.incrementAndGet()).withName("Long Island Iced tea").withPriceInCents(650).withIngredient("1 Measure", "vodka").withIngredient("1 Measure", "gin").withIngredient("1 Measure", "white rum").withIngredient("1 Measure", "tequila").withIngredient("1 Measure", "triple sec").withIngredient("3 measures", "orange juice").withIngredient("to topp up the glass", "coke").withPhotoUrl("http://xebia-cocktail.s3-website-us-east-1.amazonaws.com/6762530443361434570.jpg").withRecipeUrl("http://www.cocktailmaking.co.uk/displaycocktail.php/1069-Long-Island-Iced-tea").withInstructions("In a tall glass , add ice and all the ingredients and stir well. It should have the appearance of cloudy tea. Top with a piece of lemon\n\nVery yummy & very very deceiving. It will get you hammered after only about 2 so drink with caution");
        return longIslandIcedTea;
    }
}

