/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans;

import com.googlecode.jmxtrans.JmxTransformer;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.monitoring.ManagedJmxTransformerProcessMXBean;
import com.googlecode.jmxtrans.monitoring.ManagedObject;
import java.io.File;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ManagedJmxTransformerProcess
implements ManagedJmxTransformerProcessMXBean,
ManagedObject {
    private ObjectName objectName;
    private JmxTransformer proc;
    private final JmxTransConfiguration configuration;

    public ManagedJmxTransformerProcess(JmxTransformer proc, JmxTransConfiguration configuration) {
        this.proc = proc;
        this.configuration = configuration;
    }

    @Override
    public void start() throws LifecycleException {
        this.proc.start();
    }

    @Override
    public void stop() throws LifecycleException {
        this.proc.stop();
    }

    @Override
    public String getQuartPropertiesFile() {
        return this.configuration.getQuartPropertiesFile();
    }

    @Override
    public void setQuartPropertiesFile(String quartPropertiesFile) {
        this.configuration.setQuartPropertiesFile(quartPropertiesFile);
    }

    @Override
    public int getRunPeriod() {
        return this.configuration.getRunPeriod();
    }

    @Override
    public void setRunPeriod(int runPeriod) {
        this.configuration.setRunPeriod(runPeriod);
    }

    @Override
    public void setJsonDirOrFile(String jsonDirOrFile) {
        this.configuration.setJsonDirOrFile(new File(jsonDirOrFile));
    }

    @Override
    public String getJsonDirOrFile() {
        return this.configuration.getJsonDirOrFile().getAbsolutePath();
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("com.googlecode.jmxtrans:Type=JmxTransformerProcess,Name=JmxTransformerProcess");
        }
        return this.objectName;
    }

    @Override
    public void setObjectName(ObjectName objectName) throws MalformedObjectNameException {
        this.objectName = objectName;
    }

    @Override
    public void setObjectName(String objectName) throws MalformedObjectNameException {
        this.objectName = ObjectName.getInstance(objectName);
    }
}

