/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.cli;

import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.cli.OptionsException;
import java.io.File;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CliArgumentParser {
    public JmxTransConfiguration parseOptions(String[] args) throws OptionsException, ParseException {
        GnuParser parser = new GnuParser();
        CommandLine cl = parser.parse(this.getOptions(), args);
        Option[] options = cl.getOptions();
        JmxTransConfiguration configuration = new JmxTransConfiguration();
        for (Option option : options) {
            if (option.getOpt().equals("c")) {
                configuration.setContinueOnJsonError(Boolean.parseBoolean(option.getValue()));
                continue;
            }
            if (option.getOpt().equals("j")) {
                File jsonDir = new File(option.getValue());
                if (jsonDir.exists() && jsonDir.isDirectory()) {
                    configuration.setJsonDirOrFile(jsonDir);
                    continue;
                }
                throw new OptionsException("Path to json directory is invalid: " + jsonDir);
            }
            if (option.getOpt().equals("f")) {
                File jsonFile = new File(option.getValue());
                if (jsonFile.exists() && jsonFile.isFile()) {
                    configuration.setJsonDirOrFile(jsonFile);
                    continue;
                }
                throw new OptionsException("Path to json file is invalid: " + jsonFile);
            }
            if (option.getOpt().equals("e")) {
                configuration.setRunEndlessly(true);
                continue;
            }
            if (option.getOpt().equals("q")) {
                File quartzConfigFile = new File(option.getValue());
                if (quartzConfigFile.exists() && quartzConfigFile.isFile()) {
                    configuration.setQuartPropertiesFile(option.getValue());
                    continue;
                }
                throw new OptionsException("Could not find path to the quartz properties file: " + quartzConfigFile.getAbsolutePath());
            }
            if (option.getOpt().equals("s")) {
                try {
                    configuration.setRunPeriod(Integer.parseInt(option.getValue()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new OptionsException("Seconds between server job runs must be an integer");
                }
            }
            if (option.getOpt().equals("a")) {
                ImmutableList.Builder jars = ImmutableList.builder();
                for (String jar : option.getValues()) {
                    jars.add((Object)new File(jar));
                }
                configuration.setAdditionalJars((List<File>)jars.build());
                continue;
            }
            if (!option.getOpt().equals("h")) continue;
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar jmxtrans-all.jar", this.getOptions());
            configuration.setHelp(true);
        }
        if (!configuration.isHelp() && configuration.getJsonDirOrFile() == null) {
            throw new OptionsException("Please specify either the -f or -j option.");
        }
        return configuration;
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("c", true, "Continue processing even if one of the JSON configuration file is invalid.");
        options.addOption("j", true, "Directory where json configuration is stored. Default is .");
        options.addOption("f", true, "A single json file to execute.");
        options.addOption("e", false, "Run endlessly. Default false.");
        options.addOption("q", true, "Path to quartz configuration file.");
        options.addOption("s", true, "Seconds between server job runs (not defined with cron). Default: 60");
        OptionBuilder.withArgName((String)"a");
        OptionBuilder.withLongOpt((String)"additionalJars");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.withDescription((String)"Coma delimited list of additional jars to add to the class path");
        options.addOption(OptionBuilder.create((String)"a"));
        options.addOption("h", false, "Help");
        return options;
    }
}

