/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.connections;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class JMXConnectionParams {
    private final JMXServiceURL url;
    private final ImmutableMap<String, ?> environment;

    public JMXConnectionParams(JMXServiceURL url, Map<String, ?> environment) {
        this.url = url;
        this.environment = ImmutableMap.copyOf(environment);
    }

    public JMXServiceURL getUrl() {
        return this.url;
    }

    public ImmutableMap<String, ?> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof JMXConnectionParams)) {
            return false;
        }
        JMXConnectionParams that = (JMXConnectionParams)o;
        return new EqualsBuilder().append(this.convertArraysToLists(this.environment), this.convertArraysToLists(that.environment)).append((Object)this.url, (Object)that.url).isEquals();
    }

    private ImmutableMap<String, ?> convertArraysToLists(ImmutableMap<String, ?> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue().getClass().isArray()) {
                builder.put(entry.getKey(), this.asList(entry.getValue()));
                continue;
            }
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    private ImmutableList<?> asList(Object array) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < Array.getLength(array); ++i) {
            builder.add(Array.get(array, i));
        }
        return builder.build();
    }

    public int hashCode() {
        return new HashCodeBuilder(135, 211).append(this.convertArraysToLists(this.environment)).append((Object)this.url).toHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("url", (Object)this.url).add("environment", this.environment).toString();
    }
}

