/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jmx;

import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.jmx.JmxResultProcessor;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxQueryProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void processQuery(MBeanServerConnection mbeanServer, Server server, Query query) throws Exception {
        ObjectName oName = new ObjectName(query.getObj());
        for (ObjectName queryName : mbeanServer.queryNames(oName, null)) {
            ImmutableList<Result> results = this.fetchResults(mbeanServer, query, queryName);
            this.runOutputWritersForQuery(server, query, results);
        }
    }

    private ImmutableList<Result> fetchResults(MBeanServerConnection mbeanServer, Query query, ObjectName queryName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        ImmutableList<Result> results;
        block6: {
            Object attributes;
            MBeanInfo info = mbeanServer.getMBeanInfo(queryName);
            ObjectInstance oi = mbeanServer.getObjectInstance(queryName);
            if (query.getAttr().isEmpty()) {
                attributes = new ArrayList();
                for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
                    attributes.add(attrInfo.getName());
                }
            } else {
                attributes = query.getAttr();
            }
            results = ImmutableList.of();
            try {
                if (attributes.size() > 0) {
                    this.log.debug("Executing queryName [{}] from query [{}]", (Object)queryName.getCanonicalName(), (Object)query);
                    AttributeList al = mbeanServer.getAttributes(queryName, attributes.toArray(new String[attributes.size()]));
                    results = new JmxResultProcessor(query, oi, al.asList(), info.getClassName(), queryName.getDomain()).getResults();
                }
            }
            catch (UnmarshalException ue) {
                if (ue.getCause() == null || !(ue.getCause() instanceof ClassNotFoundException)) break block6;
                this.log.debug("Bad unmarshall, continuing. This is probably ok and due to something like this: http://ehcache.org/xref/net/sf/ehcache/distribution/RMICacheManagerPeerListener.html#52", (Object)ue.getMessage());
            }
        }
        return results;
    }

    private void runOutputWritersForQuery(Server server, Query query, ImmutableList<Result> results) throws Exception {
        for (OutputWriter writer : query.getOutputWriters()) {
            writer.doWrite(server, query, results);
        }
        this.log.debug("Finished running outputWriters for query: {}", (Object)query);
    }
}

