/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.PropertyResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"obj", "attr", "typeNames", "resultAlias", "keys", "allowDottedKeys", "outputWriters"})
@ThreadSafe
@Immutable
public class Query {
    private final String obj;
    private final ImmutableList<String> keys;
    private final ImmutableList<String> attr;
    private final ImmutableSet<String> typeNames;
    private final String resultAlias;
    private final boolean useObjDomainAsKey;
    private final boolean allowDottedKeys;
    private final ImmutableList<OutputWriter> outputWriters;

    @JsonCreator
    public Query(@JsonProperty(value="obj") String obj, @JsonProperty(value="keys") List<String> keys, @JsonProperty(value="attr") List<String> attr, @JsonProperty(value="typeNames") Set<String> typeNames, @JsonProperty(value="resultAlias") String resultAlias, @JsonProperty(value="useObjDomainAsKey") boolean useObjDomainAsKey, @JsonProperty(value="allowDottedKeys") boolean allowDottedKeys, @JsonProperty(value="outputWriters") List<OutputWriter> outputWriters) {
        this.obj = obj;
        this.attr = PropertyResolver.resolveList((List)MoreObjects.firstNonNull(attr, Collections.emptyList()));
        this.resultAlias = resultAlias;
        this.useObjDomainAsKey = (Boolean)MoreObjects.firstNonNull((Object)useObjDomainAsKey, (Object)false);
        this.keys = PropertyResolver.resolveList((List)MoreObjects.firstNonNull(keys, Collections.emptyList()));
        this.allowDottedKeys = allowDottedKeys;
        this.outputWriters = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(outputWriters, Collections.emptyList())));
        this.typeNames = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull(typeNames, Collections.emptySet())));
    }

    public String getObj() {
        return this.obj;
    }

    public String getResultAlias() {
        return this.resultAlias;
    }

    public boolean isUseObjDomainAsKey() {
        return this.useObjDomainAsKey;
    }

    public ImmutableSet<String> getTypeNames() {
        return this.typeNames;
    }

    @Nonnull
    public ImmutableList<String> getAttr() {
        return this.attr;
    }

    @Nonnull
    public ImmutableList<String> getKeys() {
        return this.keys;
    }

    public boolean isAllowDottedKeys() {
        return this.allowDottedKeys;
    }

    @Nonnull
    public ImmutableList<OutputWriter> getOutputWriters() {
        return this.outputWriters;
    }

    public String toString() {
        return "Query [obj=" + this.obj + ", useObjDomainAsKey:" + this.useObjDomainAsKey + ", resultAlias=" + this.resultAlias + ", attr=" + this.attr + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        return new EqualsBuilder().append((Object)this.getObj(), (Object)other.getObj()).append(this.getKeys(), other.getKeys()).append(this.getAttr(), other.getAttr()).append((Object)this.getResultAlias(), (Object)other.getResultAlias()).append(Query.sizeOf(this.getOutputWriters()), Query.sizeOf(other.getOutputWriters())).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(41, 97).append((Object)this.getObj()).append(this.getKeys()).append(this.getAttr()).append((Object)this.getResultAlias()).append(Query.sizeOf(this.getOutputWriters())).toHashCode();
    }

    private static int sizeOf(List<OutputWriter> writers) {
        if (writers == null) {
            return 0;
        }
        return writers.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private String obj;
        private final List<String> attr = Lists.newArrayList();
        private String resultAlias;
        private final List<String> keys = Lists.newArrayList();
        private boolean useObjDomainAsKey;
        private boolean allowDottedKeys;
        private final List<OutputWriter> outputWriters = Lists.newArrayList();
        private final Set<String> typeNames = Sets.newHashSet();

        private Builder() {
        }

        public Builder setObj(String obj) {
            this.obj = obj;
            return this;
        }

        public Builder addAttr(String ... attr) {
            this.attr.addAll(Arrays.asList(attr));
            return this;
        }

        public Builder setResultAlias(String resultAlias) {
            this.resultAlias = resultAlias;
            return this;
        }

        public Builder setUseObjDomainAsKey(boolean useObjDomainAsKey) {
            this.useObjDomainAsKey = useObjDomainAsKey;
            return this;
        }

        public Builder addKey(String keys) {
            return this.addKeys(keys);
        }

        public Builder addKeys(String ... keys) {
            this.keys.addAll(Arrays.asList(keys));
            return this;
        }

        public Builder setAllowDottedKeys(boolean allowDottedKeys) {
            this.allowDottedKeys = allowDottedKeys;
            return this;
        }

        public Builder addOutputWriter(OutputWriter outputWriter) {
            return this.addOutputWriters(outputWriter);
        }

        public Builder addOutputWriters(OutputWriter ... outputWriters) {
            this.outputWriters.addAll(Arrays.asList(outputWriters));
            return this;
        }

        public Builder setTypeNames(Set<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Query build() {
            return new Query(this.obj, this.keys, this.attr, this.typeNames, this.resultAlias, this.useObjDomainAsKey, this.allowDottedKeys, this.outputWriters);
        }
    }
}

