/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@ThreadSafe
@Immutable
public class Result {
    private final String attributeName;
    private final String className;
    private final String objDomain;
    private final String typeName;
    private final ImmutableMap<String, Object> values;
    private final long epoch;
    private final String keyAlias;

    public Result(long epoch, String attributeName, String className, String objDomain, String keyAlias, String typeName, Map<String, Object> values) {
        this.className = className;
        this.objDomain = objDomain;
        this.typeName = typeName;
        this.values = ImmutableMap.copyOf(values);
        this.epoch = epoch;
        this.attributeName = attributeName;
        this.keyAlias = keyAlias;
    }

    public String getClassName() {
        return this.className;
    }

    public String getObjDomain() {
        return this.objDomain;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Nonnull
    public ImmutableMap<String, Object> getValues() {
        return this.values;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public String toString() {
        return "Result [attributeName=" + this.attributeName + ", className=" + this.className + ", objDomain=" + this.objDomain + ", typeName=" + this.typeName + ", values=" + this.values + ", epoch=" + this.epoch + "]";
    }
}

