/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.Query;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"alias", "local", "host", "port", "username", "password", "cronExpression", "numQueryThreads", "protocolProviderPackages"})
@Immutable
@ThreadSafe
public class Server {
    private static final String FRONT = "service:jmx:rmi:///jndi/rmi://";
    private static final String BACK = "/jmxrmi";
    private final String alias;
    private final String host;
    private final String port;
    private final String username;
    private final String password;
    private final String protocolProviderPackages;
    private final String url;
    private final String cronExpression;
    private final Integer numQueryThreads;
    private final boolean local;
    private final ImmutableSet<Query> queries;

    @JsonCreator
    public Server(@JsonProperty(value="alias") String alias, @JsonProperty(value="host") String host, @JsonProperty(value="port") String port, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="protocolProviderPackages") String protocolProviderPackages, @JsonProperty(value="url") String url, @JsonProperty(value="cronExpression") String cronExpression, @JsonProperty(value="numQueryThreads") Integer numQueryThreads, @JsonProperty(value="local") boolean local, @JsonProperty(value="queries") List<Query> queries) {
        this.alias = PropertyResolver.resolveProps(alias);
        this.host = PropertyResolver.resolveProps(host);
        this.port = PropertyResolver.resolveProps(port);
        this.username = PropertyResolver.resolveProps(username);
        this.password = PropertyResolver.resolveProps(password);
        this.protocolProviderPackages = protocolProviderPackages;
        this.url = PropertyResolver.resolveProps(url);
        this.cronExpression = cronExpression;
        this.numQueryThreads = numQueryThreads;
        this.local = local;
        this.queries = ImmutableSet.copyOf(queries);
    }

    @JsonIgnore
    public ImmutableMap<String, ?> getEnvironment() {
        if (this.getProtocolProviderPackages() != null && this.getProtocolProviderPackages().contains("weblogic")) {
            ImmutableMap.Builder environment = ImmutableMap.builder();
            if (this.username != null && this.password != null) {
                environment.put((Object)"jmx.remote.protocol.provider.pkgs", (Object)this.getProtocolProviderPackages());
                environment.put((Object)"java.naming.security.principal", (Object)this.username);
                environment.put((Object)"java.naming.security.credentials", (Object)this.password);
            }
            return environment.build();
        }
        ImmutableMap.Builder environment = ImmutableMap.builder();
        if (this.username != null && this.password != null) {
            String[] credentials = new String[]{this.username, this.password};
            environment.put((Object)"jmx.remote.credentials", (Object)credentials);
        }
        return environment.build();
    }

    @JsonIgnore
    public JMXConnector getServerConnection() throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.getUrl());
        return JMXConnectorFactory.connect(url, this.getEnvironment());
    }

    @JsonIgnore
    public MBeanServer getLocalMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public String getAlias() {
        return this.alias;
    }

    public String getHost() {
        if (this.host == null && this.url == null) {
            throw new IllegalStateException("host is null and url is null. Cannot construct host dynamically.");
        }
        if (this.host != null) {
            return this.host;
        }
        return this.url.substring(this.url.lastIndexOf("//") + 2, this.url.lastIndexOf(58));
    }

    public String getPort() {
        if (this.port == null && this.url == null) {
            throw new IllegalStateException("port is null and url is null.  Cannot construct port dynamically.");
        }
        if (this.port != null) {
            return this.port;
        }
        return Server.extractPortFromUrl(this.url);
    }

    private static String extractPortFromUrl(String url) {
        String computedPort = url.substring(url.lastIndexOf(58) + 1);
        if (computedPort.contains("/")) {
            computedPort = computedPort.substring(0, computedPort.indexOf(47));
        }
        return computedPort;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLocal() {
        return this.local;
    }

    public ImmutableSet<Query> getQueries() {
        return this.queries;
    }

    public String getUrl() {
        if (this.url == null) {
            if (this.host == null || this.port == null) {
                throw new RuntimeException("url is null and host or port is null. cannot construct url dynamically.");
            }
            return FRONT + this.host + ":" + this.port + BACK;
        }
        return this.url;
    }

    @JsonIgnore
    public JMXServiceURL getJmxServiceURL() throws MalformedURLException {
        return new JMXServiceURL(this.getUrl());
    }

    @JsonIgnore
    public boolean isQueriesMultiThreaded() {
        return this.numQueryThreads != null && this.numQueryThreads > 0;
    }

    public Integer getNumQueryThreads() {
        return this.numQueryThreads;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String toString() {
        return "Server [host=" + this.host + ", port=" + this.port + ", url=" + this.url + ", cronExpression=" + this.cronExpression + ", numQueryThreads=" + this.numQueryThreads + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        return new EqualsBuilder().append((Object)this.getHost(), (Object)other.getHost()).append((Object)this.getPort(), (Object)other.getPort()).append((Object)this.getNumQueryThreads(), (Object)other.getNumQueryThreads()).append((Object)this.getCronExpression(), (Object)other.getCronExpression()).append((Object)this.getAlias(), (Object)other.getAlias()).append((Object)this.getUsername(), (Object)other.getUsername()).append((Object)this.getPassword(), (Object)other.getPassword()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 21).append((Object)this.getHost()).append((Object)this.getPort()).append((Object)this.getNumQueryThreads()).append((Object)this.getCronExpression()).append((Object)this.getAlias()).append((Object)this.getUsername()).append((Object)this.getPassword()).toHashCode();
    }

    public String getProtocolProviderPackages() {
        return this.protocolProviderPackages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Server server) {
        return new Builder(server);
    }

    @NotThreadSafe
    public static final class Builder {
        private String alias;
        private String host;
        private String port;
        private String username;
        private String password;
        private String protocolProviderPackages;
        private String url;
        private String cronExpression;
        private Integer numQueryThreads;
        private boolean local;
        private final List<Query> queries = new ArrayList<Query>();

        private Builder() {
        }

        private Builder(Server server) {
            this.alias = server.alias;
            this.host = server.host;
            this.port = server.port;
            this.username = server.username;
            this.password = server.password;
            this.protocolProviderPackages = server.protocolProviderPackages;
            this.url = server.url;
            this.cronExpression = server.cronExpression;
            this.numQueryThreads = server.numQueryThreads;
            this.local = server.local;
            this.queries.addAll((Collection<Query>)server.queries);
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setProtocolProviderPackages(String protocolProviderPackages) {
            this.protocolProviderPackages = protocolProviderPackages;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public Builder setNumQueryThreads(Integer numQueryThreads) {
            this.numQueryThreads = numQueryThreads;
            return this;
        }

        public Builder setLocal(boolean local) {
            this.local = local;
            return this;
        }

        public Builder addQuery(Query query) {
            this.queries.add(query);
            return this;
        }

        public Builder addQueries(Query ... queries) {
            this.queries.addAll(Arrays.asList(queries));
            return this;
        }

        public Builder addQueries(Set<Query> queries) {
            this.queries.addAll(queries);
            return this;
        }

        public Server build() {
            return new Server(this.alias, this.host, this.port, this.username, this.password, this.protocolProviderPackages, this.url, this.cronExpression, this.numQueryThreads, this.local, this.queries);
        }
    }
}

