/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.naming;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class KeyUtils {
    private KeyUtils() {
    }

    public static String getKeyString(Server server, Query query, Result result, Map.Entry<String, Object> values, List<String> typeNames, String rootPrefix) {
        StringBuilder sb = new StringBuilder();
        KeyUtils.addRootPrefix(rootPrefix, sb);
        KeyUtils.addAlias(server, sb);
        sb.append(".");
        KeyUtils.addMBeanIdentifier(query, result, sb);
        sb.append(".");
        KeyUtils.addTypeName(query, result, typeNames, sb);
        KeyUtils.addKeyString(query, result, values, sb);
        return sb.toString();
    }

    public static String getKeyString(Query query, Result result, Map.Entry<String, Object> values, List<String> typeNames) {
        StringBuilder sb = new StringBuilder();
        KeyUtils.addMBeanIdentifier(query, result, sb);
        sb.append(".");
        KeyUtils.addTypeName(query, result, typeNames, sb);
        KeyUtils.addKeyString(query, result, values, sb);
        return sb.toString();
    }

    private static void addRootPrefix(String rootPrefix, StringBuilder sb) {
        if (rootPrefix != null) {
            sb.append(rootPrefix);
            sb.append(".");
        }
    }

    private static void addAlias(Server server, StringBuilder sb) {
        String alias;
        if (server.getAlias() != null) {
            alias = server.getAlias();
        } else {
            alias = server.getHost() + "_" + server.getPort();
            alias = StringUtils.cleanupStr(alias);
        }
        sb.append(alias);
    }

    private static void addMBeanIdentifier(Query query, Result result, StringBuilder sb) {
        if (result.getKeyAlias() != null) {
            sb.append(result.getKeyAlias());
        } else if (query.isUseObjDomainAsKey()) {
            sb.append(StringUtils.cleanupStr(result.getObjDomain(), query.isAllowDottedKeys()));
        } else {
            sb.append(StringUtils.cleanupStr(result.getClassName()));
        }
    }

    private static void addTypeName(Query query, Result result, List<String> typeNames, StringBuilder sb) {
        String typeName = StringUtils.cleanupStr(KeyUtils.getConcatedTypeNameValues(query, typeNames, result.getTypeName()), query.isAllowDottedKeys());
        if (typeName != null && typeName.length() > 0) {
            sb.append(typeName);
            sb.append(".");
        }
    }

    private static void addKeyString(Query query, Result result, Map.Entry<String, Object> values, StringBuilder sb) {
        String keyStr = KeyUtils.computeKey(result, values);
        sb.append(StringUtils.cleanupStr(keyStr, query.isAllowDottedKeys()));
    }

    private static String computeKey(Result result, Map.Entry<String, Object> values) {
        String keyStr = values.getKey().startsWith(result.getAttributeName()) ? values.getKey() : result.getAttributeName() + "." + values.getKey();
        return keyStr;
    }

    public static String getConcatedTypeNameValues(List<String> typeNames, String typeNameStr) {
        return KeyUtils.getConcatedTypeNameValues(typeNames, typeNameStr, KeyUtils.getTypeNameValuesSeparator(null));
    }

    public static String getConcatedTypeNameValues(List<String> typeNames, String typeNameStr, String separator) {
        if (typeNames == null || typeNames.size() == 0) {
            return null;
        }
        Map<String, String> typeNameValueMap = KeyUtils.getTypeNameValueMap(typeNameStr);
        StringBuilder sb = new StringBuilder();
        for (String key : typeNames) {
            String result = typeNameValueMap.get(key);
            if (result == null) continue;
            sb.append(result);
            sb.append(separator);
        }
        return org.apache.commons.lang.StringUtils.chomp((String)sb.toString(), (String)separator);
    }

    public static Map<String, String> getTypeNameValueMap(String typeNameStr) {
        String[] tokens;
        if (typeNameStr == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (String oneToken : tokens = typeNameStr.split(",")) {
            if (oneToken.length() <= 0) continue;
            String[] keyValue = KeyUtils.splitTypeNameValue(oneToken);
            result.put(keyValue[0], keyValue[1]);
        }
        return result;
    }

    public static String getConcatedTypeNameValues(Query query, List<String> typeNames, String typeName) {
        ImmutableSet<String> queryTypeNames = query.getTypeNames();
        if (queryTypeNames != null && queryTypeNames.size() > 0) {
            ArrayList<String> filteredTypeNames = new ArrayList<String>((Collection<String>)queryTypeNames);
            for (String name : typeNames) {
                if (filteredTypeNames.contains(name)) continue;
                filteredTypeNames.add(name);
            }
            return KeyUtils.getConcatedTypeNameValues(filteredTypeNames, typeName, KeyUtils.getTypeNameValuesSeparator(query));
        }
        return KeyUtils.getConcatedTypeNameValues(typeNames, typeName, KeyUtils.getTypeNameValuesSeparator(query));
    }

    private static String getTypeNameValuesSeparator(Query query) {
        if (query != null && query.isAllowDottedKeys()) {
            return ".";
        }
        return "_";
    }

    private static String[] splitTypeNameValue(String typeNameToken) {
        String[] keys = typeNameToken.split("=", 2);
        String[] result = keys.length == 2 ? keys : new String[]{keys[0], ""};
        return result;
    }
}

