/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.model.results.BooleanAsNumberValueTransformer;
import com.googlecode.jmxtrans.model.results.IdentityValueTransformer;
import com.googlecode.jmxtrans.model.results.ValueTransformer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class BaseOutputWriter
implements OutputWriter {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String OUTPUT_FILE = "outputFile";
    public static final String TEMPLATE_FILE = "templateFile";
    public static final String BINARY_PATH = "binaryPath";
    public static final String DEBUG = "debug";
    public static final String TYPE_NAMES = "typeNames";
    public static final String BOOLEAN_AS_NUMBER = "booleanAsNumber";
    private ImmutableList<String> typeNames;
    private boolean debugEnabled;
    private Map<String, Object> settings;
    private final ValueTransformer valueTransformer;

    @JsonCreator
    public BaseOutputWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="settings") Map<String, Object> settings) {
        this.settings = PropertyResolver.resolveMap((Map)MoreObjects.firstNonNull(settings, Collections.emptyMap()));
        this.typeNames = ImmutableList.copyOf((Collection)this.firstNonNull(typeNames, (List)this.settings.get(TYPE_NAMES), Collections.emptyList()));
        this.debugEnabled = this.firstNonNull(debugEnabled, Settings.getBooleanSetting(this.settings, DEBUG), false);
        booleanAsNumber = Settings.getBooleanSetting(this.settings, BOOLEAN_AS_NUMBER, booleanAsNumber);
        this.valueTransformer = booleanAsNumber ? new BooleanAsNumberValueTransformer(1, 0) : new IdentityValueTransformer();
    }

    protected <T> T firstNonNull(@Nullable T first, @Nullable T second, @Nullable T third) {
        return (T)(first != null ? first : (second != null ? second : Preconditions.checkNotNull(third)));
    }

    @Override
    @Deprecated
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    @Override
    @Deprecated
    public void setSettings(Map<String, Object> settings) {
        this.settings = PropertyResolver.resolveMap(settings);
        if (settings.containsKey(DEBUG)) {
            this.debugEnabled = Settings.getBooleanSetting(settings, DEBUG);
        }
        if (settings.containsKey(TYPE_NAMES)) {
            this.typeNames = ImmutableList.copyOf((Collection)((List)settings.get(TYPE_NAMES)));
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public List<String> getTypeNames() {
        return this.typeNames;
    }

    protected String getConcatedTypeNameValues(String typeNameStr) {
        return KeyUtils.getConcatedTypeNameValues(this.getTypeNames(), typeNameStr);
    }

    @Override
    public void start() throws LifecycleException {
    }

    @Override
    public void stop() throws LifecycleException {
    }

    @Override
    public final void doWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.internalWrite(server, query, (ImmutableList<Result>)FluentIterable.from(results).transform((Function)new ResultValuesTransformer(this.valueTransformer)).toList());
    }

    protected abstract void internalWrite(Server var1, Query var2, ImmutableList<Result> var3) throws Exception;

    private static final class ResultValuesTransformer
    implements Function<Result, Result> {
        private final ValueTransformer valueTransformer;

        private ResultValuesTransformer(ValueTransformer valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Nullable
        public Result apply(@Nullable Result input) {
            if (input == null) {
                return null;
            }
            return new Result(input.getEpoch(), input.getAttributeName(), input.getClassName(), input.getObjDomain(), input.getKeyAlias(), input.getTypeName(), Maps.transformValues(input.getValues(), (Function)this.valueTransformer));
        }
    }
}

