/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jmx;

import com.googlecode.jmxtrans.jmx.JmxQueryProcessor;
import com.googlecode.jmxtrans.jmx.ProcessQueryThread;
import com.googlecode.jmxtrans.jmx.ProcessServerThread;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processServer(Server server, JMXConnector conn) throws Exception {
        MBeanServerConnection mbeanServer = server.isLocal() ? server.getLocalMBeanServer() : conn.getMBeanServerConnection();
        if (server.isQueriesMultiThreaded()) {
            ExecutorService service = null;
            try {
                service = Executors.newFixedThreadPool(server.getNumQueryThreads());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("----- Creating " + server.getQueries().size() + " query threads");
                }
                ArrayList<Callable<Object>> threads = new ArrayList<Callable<Object>>(server.getQueries().size());
                for (Query query : server.getQueries()) {
                    ProcessQueryThread pqt = new ProcessQueryThread(mbeanServer, server, query);
                    threads.add(Executors.callable(pqt));
                }
                service.invokeAll(threads);
            }
            finally {
                if (service != null) {
                    this.shutdownAndAwaitTermination(service);
                }
            }
        } else {
            for (Query query : server.getQueries()) {
                new JmxQueryProcessor().processQuery(mbeanServer, server, query);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JmxProcess process) throws Exception {
        ArrayList<JMXConnector> conns = new ArrayList<JMXConnector>();
        if (process.isServersMultiThreaded()) {
            ExecutorService service = null;
            try {
                service = Executors.newFixedThreadPool(process.getNumMultiThreadedServers());
                for (Server server : process.getServers()) {
                    if (server.isLocal() && server.getLocalMBeanServer() != null) {
                        service.execute(new ProcessServerThread(server, null, this));
                        continue;
                    }
                    JMXConnector conn = server.getServerConnection();
                    conns.add(conn);
                    service.execute(new ProcessServerThread(server, conn, this));
                }
                service.shutdown();
            }
            finally {
                try {
                    if (service != null) {
                        service.awaitTermination(60000L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException ex) {
                    this.log.error("Error shutting down execution.", (Throwable)ex);
                }
            }
        }
        for (Server server : process.getServers()) {
            if (server.getLocalMBeanServer() != null) {
                this.processServer(server, null);
                continue;
            }
            JMXConnector conn = server.getServerConnection();
            conns.add(conn);
            this.processServer(server, conn);
        }
        for (JMXConnector conn : conns) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                this.log.error("Error closing connection.", (Throwable)ex);
            }
        }
    }

    private void shutdownAndAwaitTermination(ExecutorService service) {
        service.shutdown();
        try {
            if (!service.awaitTermination(60L, TimeUnit.SECONDS)) {
                service.shutdownNow();
                if (!service.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.log.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            service.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

