/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jobs;

import com.googlecode.jmxtrans.connections.JMXConnectionParams;
import com.googlecode.jmxtrans.jmx.JmxUtils;
import com.googlecode.jmxtrans.model.Server;
import java.util.Map;
import javax.inject.Inject;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(ServerJob.class);
    private final GenericKeyedObjectPool<JMXConnectionParams, JMXConnector> jmxPool;
    private final JmxUtils jmxUtils;

    @Inject
    public ServerJob(GenericKeyedObjectPool<JMXConnectionParams, JMXConnector> jmxPool, JmxUtils jmxUtils) {
        this.jmxPool = jmxPool;
        this.jmxUtils = jmxUtils;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap map = context.getMergedJobDataMap();
        Server server = (Server)map.get((Object)Server.class.getName());
        log.debug("+++++ Started server job: {}", (Object)server);
        JMXConnector conn = null;
        JMXConnectionParams connectionParams = null;
        try {
            JMXServiceURL jmxUrl = server.getJmxServiceURL();
            connectionParams = new JMXConnectionParams(jmxUrl, (Map<String, ?>)server.getEnvironment());
            if (!server.isLocal()) {
                conn = (JMXConnector)this.jmxPool.borrowObject((Object)connectionParams);
            }
            this.jmxUtils.processServer(server, conn);
        }
        catch (Exception e) {
            try {
                log.error("Error in job for server: " + server, (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.jmxPool.returnObject(connectionParams, conn);
                    throw throwable;
                }
                catch (Exception ex) {
                    log.error("Error returning object to pool for server: " + server);
                }
                throw throwable;
            }
        }
        try {
            this.jmxPool.returnObject((Object)connectionParams, (Object)conn);
        }
        catch (Exception ex) {
            log.error("Error returning object to pool for server: " + server);
        }
        log.debug("+++++ Finished server job: {}", (Object)server);
    }
}

