/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.naming.typename.PrependingTypeNameValuesStringBuilder;
import com.googlecode.jmxtrans.model.naming.typename.TypeNameValuesStringBuilder;
import com.googlecode.jmxtrans.model.naming.typename.UseAllTypeNameValuesStringBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"obj", "attr", "typeNames", "resultAlias", "keys", "allowDottedKeys", "useAllTypeNames", "outputWriters"})
@ThreadSafe
@Immutable
public class Query {
    private final String obj;
    @Nonnull
    private final ImmutableList<String> keys;
    @Nonnull
    private final ImmutableList<String> attr;
    private final ImmutableSet<String> typeNames;
    private final String resultAlias;
    private final boolean useObjDomainAsKey;
    private final boolean allowDottedKeys;
    private final boolean useAllTypeNames;
    @Nonnull
    private final ImmutableList<OutputWriterFactory> outputWriters;
    private final TypeNameValuesStringBuilder typeNameValuesStringBuilder;

    @JsonCreator
    public Query(@JsonProperty(value="obj") String obj, @JsonProperty(value="keys") List<String> keys, @JsonProperty(value="attr") List<String> attr, @JsonProperty(value="typeNames") Set<String> typeNames, @JsonProperty(value="resultAlias") String resultAlias, @JsonProperty(value="useObjDomainAsKey") boolean useObjDomainAsKey, @JsonProperty(value="allowDottedKeys") boolean allowDottedKeys, @JsonProperty(value="useAllTypeNames") boolean useAllTypeNames, @JsonProperty(value="outputWriters") List<OutputWriterFactory> outputWriters) {
        this.obj = obj;
        this.attr = PropertyResolver.resolveList((List)MoreObjects.firstNonNull(attr, Collections.emptyList()));
        this.resultAlias = resultAlias;
        this.useObjDomainAsKey = (Boolean)MoreObjects.firstNonNull((Object)useObjDomainAsKey, (Object)false);
        this.keys = PropertyResolver.resolveList((List)MoreObjects.firstNonNull(keys, Collections.emptyList()));
        this.allowDottedKeys = allowDottedKeys;
        this.useAllTypeNames = useAllTypeNames;
        this.outputWriters = ImmutableList.copyOf(outputWriters);
        this.typeNames = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull(typeNames, Collections.emptySet())));
        this.typeNameValuesStringBuilder = this.makeTypeNameValuesStringBuilder();
    }

    public String makeTypeNameValueString(List<String> typeNames, String typeNameStr) {
        return this.typeNameValuesStringBuilder.build(typeNames, typeNameStr);
    }

    public Iterable<OutputWriter> getOutputWriterInstances() {
        return FluentIterable.from(this.outputWriters).transform((Function)new Function<OutputWriterFactory, OutputWriter>(){

            @Nullable
            public OutputWriter apply(OutputWriterFactory input) {
                return input.create();
            }
        }).toList();
    }

    public String toString() {
        return "Query [obj=" + this.obj + ", useObjDomainAsKey:" + this.useObjDomainAsKey + ", resultAlias=" + this.resultAlias + ", attr=" + this.attr + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        return new EqualsBuilder().append((Object)this.getObj(), (Object)other.getObj()).append(this.getKeys(), other.getKeys()).append(this.getAttr(), other.getAttr()).append((Object)this.getResultAlias(), (Object)other.getResultAlias()).append(Query.sizeOf(this.getOutputWriters()), Query.sizeOf(other.getOutputWriters())).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(41, 97).append((Object)this.getObj()).append(this.getKeys()).append(this.getAttr()).append((Object)this.getResultAlias()).append(Query.sizeOf(this.getOutputWriters())).toHashCode();
    }

    private static int sizeOf(List<?> writers) {
        if (writers == null) {
            return 0;
        }
        return writers.size();
    }

    private TypeNameValuesStringBuilder makeTypeNameValuesStringBuilder() {
        String separator = this.isAllowDottedKeys() ? "." : "_";
        ImmutableSet<String> typeNames = this.getTypeNames();
        if (this.isUseAllTypeNames()) {
            return new UseAllTypeNameValuesStringBuilder(separator);
        }
        if (typeNames != null && typeNames.size() > 0) {
            return new PrependingTypeNameValuesStringBuilder(separator, new ArrayList<String>((Collection<String>)typeNames));
        }
        return new TypeNameValuesStringBuilder(separator);
    }

    public static Builder builder() {
        return new Builder();
    }

    @SuppressFBWarnings(justification="generated code")
    public String getObj() {
        return this.obj;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<String> getKeys() {
        return this.keys;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<String> getAttr() {
        return this.attr;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableSet<String> getTypeNames() {
        return this.typeNames;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getResultAlias() {
        return this.resultAlias;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUseObjDomainAsKey() {
        return this.useObjDomainAsKey;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isAllowDottedKeys() {
        return this.allowDottedKeys;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUseAllTypeNames() {
        return this.useAllTypeNames;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<OutputWriterFactory> getOutputWriters() {
        return this.outputWriters;
    }

    @NotThreadSafe
    public static final class Builder {
        private String obj;
        private final List<String> attr = Lists.newArrayList();
        private String resultAlias;
        private final List<String> keys = Lists.newArrayList();
        private boolean useObjDomainAsKey;
        private boolean allowDottedKeys;
        private boolean useAllTypeNames;
        private final List<OutputWriterFactory> outputWriters = Lists.newArrayList();
        private final Set<String> typeNames = Sets.newHashSet();

        private Builder() {
        }

        public Builder addAttr(String ... attr) {
            this.attr.addAll(Arrays.asList(attr));
            return this;
        }

        public Builder addKey(String keys) {
            return this.addKeys(keys);
        }

        public Builder addKeys(String ... keys) {
            this.keys.addAll(Arrays.asList(keys));
            return this;
        }

        public Builder addOutputWriter(OutputWriterFactory outputWriter) {
            return this.addOutputWriters(outputWriter);
        }

        public Builder addOutputWriters(OutputWriterFactory ... outputWriters) {
            this.outputWriters.addAll(Arrays.asList(outputWriters));
            return this;
        }

        public Builder setTypeNames(Set<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Query build() {
            return new Query(this.obj, this.keys, this.attr, this.typeNames, this.resultAlias, this.useObjDomainAsKey, this.allowDottedKeys, this.useAllTypeNames, this.outputWriters);
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setObj(String obj) {
            this.obj = obj;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setResultAlias(String resultAlias) {
            this.resultAlias = resultAlias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setUseObjDomainAsKey(boolean useObjDomainAsKey) {
            this.useObjDomainAsKey = useObjDomainAsKey;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setAllowDottedKeys(boolean allowDottedKeys) {
            this.allowDottedKeys = allowDottedKeys;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setUseAllTypeNames(boolean useAllTypeNames) {
            this.useAllTypeNames = useAllTypeNames;
            return this;
        }
    }
}

