/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.Query;
import com.sun.tools.attach.VirtualMachine;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"alias", "local", "pid", "host", "port", "username", "password", "cronExpression", "numQueryThreads", "protocolProviderPackages"})
@Immutable
@ThreadSafe
public class Server {
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String FRONT = "service:jmx:rmi:///jndi/rmi://";
    private static final String BACK = "/jmxrmi";
    private final String alias;
    private final String pid;
    private final String host;
    private final String port;
    private final String username;
    private final String password;
    private final String protocolProviderPackages;
    private final String url;
    private final String cronExpression;
    private final Integer numQueryThreads;
    private final boolean local;
    private final ImmutableSet<Query> queries;

    @JsonCreator
    public Server(@JsonProperty(value="alias") String alias, @JsonProperty(value="pid") String pid, @JsonProperty(value="host") String host, @JsonProperty(value="port") String port, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="protocolProviderPackages") String protocolProviderPackages, @JsonProperty(value="url") String url, @JsonProperty(value="cronExpression") String cronExpression, @JsonProperty(value="numQueryThreads") Integer numQueryThreads, @JsonProperty(value="local") boolean local, @JsonProperty(value="queries") List<Query> queries) {
        Preconditions.checkArgument((pid != null || url != null || host != null ? 1 : 0) != 0, (Object)"You must provide the pid or the [url|host and port]");
        Preconditions.checkArgument((pid == null || url == null && host == null ? 1 : 0) != 0, (Object)"You must provide the pid OR the url, not both");
        this.alias = PropertyResolver.resolveProps(alias);
        this.pid = PropertyResolver.resolveProps(pid);
        this.port = PropertyResolver.resolveProps(port);
        this.username = PropertyResolver.resolveProps(username);
        this.password = PropertyResolver.resolveProps(password);
        this.protocolProviderPackages = protocolProviderPackages;
        this.url = PropertyResolver.resolveProps(url);
        this.cronExpression = cronExpression;
        this.numQueryThreads = numQueryThreads;
        this.local = local;
        this.queries = ImmutableSet.copyOf(queries);
        if (pid != null) {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.host = PropertyResolver.resolveProps(host);
        }
    }

    @JsonIgnore
    public ImmutableMap<String, ?> getEnvironment() {
        if (this.getProtocolProviderPackages() != null && this.getProtocolProviderPackages().contains("weblogic")) {
            ImmutableMap.Builder environment = ImmutableMap.builder();
            if (this.username != null && this.password != null) {
                environment.put((Object)"jmx.remote.protocol.provider.pkgs", (Object)this.getProtocolProviderPackages());
                environment.put((Object)"java.naming.security.principal", (Object)this.username);
                environment.put((Object)"java.naming.security.credentials", (Object)this.password);
            }
            return environment.build();
        }
        ImmutableMap.Builder environment = ImmutableMap.builder();
        if (this.username != null && this.password != null) {
            String[] credentials = new String[]{this.username, this.password};
            environment.put((Object)"jmx.remote.credentials", (Object)credentials);
        }
        return environment.build();
    }

    @JsonIgnore
    public JMXConnector getServerConnection() throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.getUrl());
        return JMXConnectorFactory.connect(url, this.getEnvironment());
    }

    @JsonIgnore
    public MBeanServer getLocalMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public String getHost() {
        if (this.host == null && this.url == null) {
            return null;
        }
        if (this.host != null) {
            return this.host;
        }
        return this.url.substring(this.url.lastIndexOf("//") + 2, this.url.lastIndexOf(58));
    }

    public String getSource() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getHost();
    }

    public String getPort() {
        if (this.port == null && this.url == null) {
            return null;
        }
        if (this.port != null) {
            return this.port;
        }
        return Server.extractPortFromUrl(this.url);
    }

    private static String extractPortFromUrl(String url) {
        String computedPort = url.substring(url.lastIndexOf(58) + 1);
        if (computedPort.contains("/")) {
            computedPort = computedPort.substring(0, computedPort.indexOf(47));
        }
        return computedPort;
    }

    public String getUrl() {
        if (this.url == null) {
            if (this.host == null || this.port == null) {
                return null;
            }
            return FRONT + this.host + ":" + this.port + BACK;
        }
        return this.url;
    }

    @JsonIgnore
    public JMXServiceURL getJmxServiceURL() throws IOException {
        if (this.pid != null) {
            return JMXServiceURLFactory.extractJMXServiceURLFromPid(this.pid);
        }
        return new JMXServiceURL(this.getUrl());
    }

    @JsonIgnore
    public boolean isQueriesMultiThreaded() {
        return this.numQueryThreads != null && this.numQueryThreads > 0;
    }

    public String toString() {
        String msg = this.pid != null ? "pid=" + this.pid : "host=" + this.host + ", port=" + this.port + ", url=" + this.url;
        return "Server [" + msg + ", cronExpression=" + this.cronExpression + ", numQueryThreads=" + this.numQueryThreads + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        return new EqualsBuilder().append((Object)this.getHost(), (Object)other.getHost()).append((Object)this.getPort(), (Object)other.getPort()).append((Object)this.getPid(), (Object)other.getPid()).append((Object)this.getNumQueryThreads(), (Object)other.getNumQueryThreads()).append((Object)this.getCronExpression(), (Object)other.getCronExpression()).append((Object)this.getAlias(), (Object)other.getAlias()).append((Object)this.getUsername(), (Object)other.getUsername()).append((Object)this.getPassword(), (Object)other.getPassword()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 21).append((Object)this.getHost()).append((Object)this.getPort()).append((Object)this.getPid()).append((Object)this.getNumQueryThreads()).append((Object)this.getCronExpression()).append((Object)this.getAlias()).append((Object)this.getUsername()).append((Object)this.getPassword()).toHashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Server server) {
        return new Builder(server);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getAlias() {
        return this.alias;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getPid() {
        return this.pid;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getUsername() {
        return this.username;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getPassword() {
        return this.password;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getProtocolProviderPackages() {
        return this.protocolProviderPackages;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getCronExpression() {
        return this.cronExpression;
    }

    @SuppressFBWarnings(justification="generated code")
    public Integer getNumQueryThreads() {
        return this.numQueryThreads;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isLocal() {
        return this.local;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableSet<Query> getQueries() {
        return this.queries;
    }

    @NotThreadSafe
    public static final class Builder {
        private String alias;
        private String pid;
        private String host;
        private String port;
        private String username;
        private String password;
        private String protocolProviderPackages;
        private String url;
        private String cronExpression;
        private Integer numQueryThreads;
        private boolean local;
        private final List<Query> queries = new ArrayList<Query>();

        private Builder() {
        }

        private Builder(Server server) {
            this.alias = server.alias;
            this.pid = server.pid;
            this.host = server.pid != null ? null : server.host;
            this.port = server.port;
            this.username = server.username;
            this.password = server.password;
            this.protocolProviderPackages = server.protocolProviderPackages;
            this.url = server.url;
            this.cronExpression = server.cronExpression;
            this.numQueryThreads = server.numQueryThreads;
            this.local = server.local;
            this.queries.addAll((Collection<Query>)server.queries);
        }

        public Builder setProtocolProviderPackages(String protocolProviderPackages) {
            this.protocolProviderPackages = protocolProviderPackages;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public Builder setNumQueryThreads(Integer numQueryThreads) {
            this.numQueryThreads = numQueryThreads;
            return this;
        }

        public Builder setLocal(boolean local) {
            this.local = local;
            return this;
        }

        public Builder addQuery(Query query) {
            this.queries.add(query);
            return this;
        }

        public Builder addQueries(Query ... queries) {
            this.queries.addAll(Arrays.asList(queries));
            return this;
        }

        public Builder addQueries(Set<Query> queries) {
            this.queries.addAll(queries);
            return this;
        }

        public Server build() {
            return new Server(this.alias, this.pid, this.host, this.port, this.username, this.password, this.protocolProviderPackages, this.url, this.cronExpression, this.numQueryThreads, this.local, this.queries);
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setPid(String pid) {
            this.pid = pid;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setPort(String port) {
            this.port = port;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }
    }

    private static class JMXServiceURLFactory {
        private JMXServiceURLFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static JMXServiceURL extractJMXServiceURLFromPid(String pid) throws IOException {
            JMXServiceURL jMXServiceURL;
            VirtualMachine vm = VirtualMachine.attach(pid);
            try {
                String connectorAddress = vm.getAgentProperties().getProperty(Server.CONNECTOR_ADDRESS);
                if (connectorAddress == null) {
                    String agent = vm.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
                    vm.loadAgent(agent);
                    connectorAddress = vm.getAgentProperties().getProperty(Server.CONNECTOR_ADDRESS);
                }
                jMXServiceURL = new JMXServiceURL(connectorAddress);
            }
            catch (Throwable throwable) {
                try {
                    vm.detach();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            vm.detach();
            return jMXServiceURL;
        }
    }
}

