/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.guice;

import com.google.common.io.Closer;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.connections.DatagramSocketFactory;
import com.googlecode.jmxtrans.connections.SocketFactory;
import com.googlecode.jmxtrans.guice.GuiceJobFactory;
import com.googlecode.jmxtrans.monitoring.ManagedGenericKeyedObjectPool;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.annotation.Nonnull;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTransModule
extends AbstractModule {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JmxTransConfiguration configuration;

    public JmxTransModule(@Nonnull JmxTransConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<GenericKeyedObjectPool<InetSocketAddress, Socket>>(){}).toInstance((Object)this.getObjectPool((KeyedPoolableObjectFactory)new SocketFactory(), SocketFactory.class.getSimpleName()));
        this.bind((TypeLiteral)new TypeLiteral<GenericKeyedObjectPool<SocketAddress, DatagramSocket>>(){}).toInstance((Object)this.getObjectPool((KeyedPoolableObjectFactory)new DatagramSocketFactory(), DatagramSocketFactory.class.getSimpleName()));
    }

    @Provides
    JmxTransConfiguration jmxTransConfiguration() {
        return this.configuration;
    }

    @Provides
    @Inject
    Scheduler scheduler(JmxTransConfiguration configuration, GuiceJobFactory jobFactory) throws SchedulerException, IOException {
        StdSchedulerFactory serverSchedFact = new StdSchedulerFactory();
        Closer closer = Closer.create();
        try {
            InputStream stream = configuration.getQuartzPropertiesFile() == null ? (InputStream)closer.register((Closeable)JmxTransModule.class.getResourceAsStream("/quartz.server.properties")) : (InputStream)closer.register((Closeable)new FileInputStream(configuration.getQuartzPropertiesFile()));
            serverSchedFact.initialize(stream);
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        Scheduler scheduler = serverSchedFact.getScheduler();
        scheduler.setJobFactory((JobFactory)jobFactory);
        return scheduler;
    }

    private <K, V> GenericKeyedObjectPool getObjectPool(KeyedPoolableObjectFactory<K, V> factory, String poolName) {
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);
        pool.setTestOnBorrow(true);
        pool.setMaxActive(-1);
        pool.setMaxIdle(-1);
        pool.setTimeBetweenEvictionRunsMillis(300000L);
        pool.setMinEvictableIdleTimeMillis(300000L);
        try {
            ManagedGenericKeyedObjectPool mbean = new ManagedGenericKeyedObjectPool(pool, poolName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, mbean.getObjectName());
        }
        catch (Exception e) {
            this.log.error("Could not register mbean for pool [{}]", (Object)poolName, (Object)e);
        }
        return pool;
    }
}

