/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jmx;

import com.googlecode.jmxtrans.jmx.ProcessQueryThread;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stormpot.Timeout;

public class JmxUtils {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processServer(Server server) throws Exception {
        if (server.isQueriesMultiThreaded()) {
            ExecutorService service = null;
            try {
                service = Executors.newFixedThreadPool(server.getNumQueryThreads());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("----- Creating " + server.getQueries().size() + " query threads");
                }
                ArrayList<Callable<Object>> threads = new ArrayList<Callable<Object>>(server.getQueries().size());
                for (Query query : server.getQueries()) {
                    ProcessQueryThread pqt = new ProcessQueryThread(server, query);
                    threads.add(Executors.callable(pqt));
                }
                service.invokeAll(threads);
            }
            finally {
                if (service != null) {
                    this.shutdownAndAwaitTermination(service);
                }
            }
        } else {
            for (Query query : server.getQueries()) {
                Iterable<Result> results = server.execute(query, new Timeout(1L, TimeUnit.SECONDS));
                query.runOutputWritersForQuery(server, results);
            }
        }
    }

    private void shutdownAndAwaitTermination(ExecutorService service) {
        service.shutdown();
        try {
            if (!service.awaitTermination(60L, TimeUnit.SECONDS)) {
                service.shutdownNow();
                if (!service.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.log.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            service.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

