/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jmx;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stormpot.Timeout;

public class ProcessQueryThread
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Server server;
    private final Query query;

    public ProcessQueryThread(Server server, Query query) {
        this.server = server;
        this.query = query;
    }

    @Override
    public void run() {
        try {
            Iterable<Result> results = this.server.execute(this.query, new Timeout(1L, TimeUnit.SECONDS));
            this.query.runOutputWritersForQuery(this.server, results);
        }
        catch (Exception e) {
            this.log.error("Error executing query: " + this.query, (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

