/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.googlecode.jmxtrans.model.MBeanServerConnectionPoolable;
import com.googlecode.jmxtrans.model.Server;
import javax.annotation.Nonnull;
import javax.management.remote.JMXConnector;
import stormpot.Allocator;
import stormpot.Slot;

public class MBeanServerConnectionAllocator
implements Allocator<MBeanServerConnectionPoolable> {
    @Nonnull
    private final Server server;

    public MBeanServerConnectionAllocator(@Nonnull Server server) {
        this.server = server;
    }

    public MBeanServerConnectionPoolable allocate(Slot slot) throws Exception {
        if (this.server.isLocal()) {
            return new MBeanServerConnectionPoolable(slot, null, this.server.getLocalMBeanServer());
        }
        JMXConnector connection = this.server.getServerConnection();
        return new MBeanServerConnectionPoolable(slot, connection, connection.getMBeanServerConnection());
    }

    public void deallocate(MBeanServerConnectionPoolable poolable) throws Exception {
        JMXConnector connector = poolable.getJmxConnector();
        if (connector != null) {
            connector.close();
        }
    }
}

