/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.googlecode.jmxtrans.model.JmxResultProcessor;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.PropertyResolver;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.typename.PrependingTypeNameValuesStringBuilder;
import com.googlecode.jmxtrans.model.naming.typename.TypeNameValuesStringBuilder;
import com.googlecode.jmxtrans.model.naming.typename.UseAllTypeNameValuesStringBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonPropertyOrder(value={"obj", "attr", "typeNames", "resultAlias", "keys", "allowDottedKeys", "useAllTypeNames", "outputWriters"})
@ThreadSafe
public class Query {
    private static final Logger logger = LoggerFactory.getLogger(Query.class);
    @Nonnull
    private final ObjectName objectName;
    @Nonnull
    private final ImmutableList<String> keys;
    @Nonnull
    private final ImmutableList<String> attr;
    private final ImmutableSet<String> typeNames;
    private final String resultAlias;
    private final boolean useObjDomainAsKey;
    private final boolean allowDottedKeys;
    private final boolean useAllTypeNames;
    @Nonnull
    private final ImmutableList<OutputWriterFactory> outputWriters;
    @Nonnull
    private final Iterable<OutputWriter> outputWriterInstances;
    private final TypeNameValuesStringBuilder typeNameValuesStringBuilder;

    @JsonCreator
    public Query(@JsonProperty(value="obj") String obj, @JsonProperty(value="keys") List<String> keys, @JsonProperty(value="attr") List<String> attr, @JsonProperty(value="typeNames") Set<String> typeNames, @JsonProperty(value="resultAlias") String resultAlias, @JsonProperty(value="useObjDomainAsKey") boolean useObjDomainAsKey, @JsonProperty(value="allowDottedKeys") boolean allowDottedKeys, @JsonProperty(value="useAllTypeNames") boolean useAllTypeNames, @JsonProperty(value="outputWriters") List<OutputWriterFactory> outputWriters) {
        try {
            this.objectName = new ObjectName(obj);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name: " + obj);
        }
        this.attr = PropertyResolver.resolveList((List)MoreObjects.firstNonNull(attr, Collections.emptyList()));
        this.resultAlias = resultAlias;
        this.useObjDomainAsKey = (Boolean)MoreObjects.firstNonNull((Object)useObjDomainAsKey, (Object)false);
        this.keys = PropertyResolver.resolveList((List)MoreObjects.firstNonNull(keys, Collections.emptyList()));
        this.allowDottedKeys = allowDottedKeys;
        this.useAllTypeNames = useAllTypeNames;
        this.outputWriters = ImmutableList.copyOf(outputWriters);
        this.typeNames = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull(typeNames, Collections.emptySet())));
        this.typeNameValuesStringBuilder = this.makeTypeNameValuesStringBuilder();
        this.outputWriterInstances = this.createOutputWriters(outputWriters);
    }

    private ImmutableList<OutputWriter> createOutputWriters(Iterable<OutputWriterFactory> outputWriters) {
        return FluentIterable.from(outputWriters).transform((Function)new Function<OutputWriterFactory, OutputWriter>(){

            @Nullable
            public OutputWriter apply(OutputWriterFactory input) {
                return input.create();
            }
        }).toList();
    }

    public String makeTypeNameValueString(List<String> typeNames, String typeNameStr) {
        return this.typeNameValuesStringBuilder.build(typeNames, typeNameStr);
    }

    public Iterable<ObjectName> queryNames(MBeanServerConnection mbeanServer) throws IOException {
        return mbeanServer.queryNames(this.objectName, null);
    }

    public Iterable<Result> fetchResults(MBeanServerConnection mbeanServer, ObjectName queryName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        Object attributes;
        MBeanInfo info = mbeanServer.getMBeanInfo(queryName);
        ObjectInstance oi = mbeanServer.getObjectInstance(queryName);
        if (this.attr.isEmpty()) {
            attributes = new ArrayList();
            for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
                attributes.add(attrInfo.getName());
            }
        } else {
            attributes = this.attr;
        }
        try {
            if (attributes.size() > 0) {
                logger.debug("Executing queryName [{}] from query [{}]", (Object)queryName.getCanonicalName(), (Object)this);
                AttributeList al = mbeanServer.getAttributes(queryName, attributes.toArray(new String[attributes.size()]));
                return new JmxResultProcessor(this, oi, al.asList(), info.getClassName(), queryName.getDomain()).getResults();
            }
        }
        catch (UnmarshalException ue) {
            if (ue.getCause() != null && ue.getCause() instanceof ClassNotFoundException) {
                logger.debug("Bad unmarshall, continuing. This is probably ok and due to something like this: http://ehcache.org/xref/net/sf/ehcache/distribution/RMICacheManagerPeerListener.html#52", (Object)ue.getMessage());
            }
            throw ue;
        }
        return ImmutableList.of();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        return new EqualsBuilder().append((Object)this.getObjectName(), (Object)other.getObjectName()).append(this.getKeys(), other.getKeys()).append(this.getAttr(), other.getAttr()).append((Object)this.getResultAlias(), (Object)other.getResultAlias()).append(Query.sizeOf(this.getOutputWriters()), Query.sizeOf(other.getOutputWriters())).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(41, 97).append((Object)this.getObjectName()).append(this.getKeys()).append(this.getAttr()).append((Object)this.getResultAlias()).append(Query.sizeOf(this.getOutputWriters())).toHashCode();
    }

    private static int sizeOf(List<?> writers) {
        if (writers == null) {
            return 0;
        }
        return writers.size();
    }

    private TypeNameValuesStringBuilder makeTypeNameValuesStringBuilder() {
        String separator = this.isAllowDottedKeys() ? "." : "_";
        ImmutableSet<String> typeNames = this.getTypeNames();
        if (this.isUseAllTypeNames()) {
            return new UseAllTypeNameValuesStringBuilder(separator);
        }
        if (typeNames != null && typeNames.size() > 0) {
            return new PrependingTypeNameValuesStringBuilder(separator, new ArrayList<String>((Collection<String>)typeNames));
        }
        return new TypeNameValuesStringBuilder(separator);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void runOutputWritersForQuery(Server server, Iterable<Result> results) throws Exception {
        for (OutputWriter writer : this.getOutputWriterInstances()) {
            writer.doWrite(server, this, results);
        }
        logger.debug("Finished running outputWriters for query: {}", (Object)this);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Query(objectName=" + this.getObjectName() + ", keys=" + this.getKeys() + ", attr=" + this.getAttr() + ", typeNames=" + this.getTypeNames() + ", resultAlias=" + this.getResultAlias() + ", useObjDomainAsKey=" + this.isUseObjDomainAsKey() + ", allowDottedKeys=" + this.isAllowDottedKeys() + ", useAllTypeNames=" + this.isUseAllTypeNames() + ", outputWriterInstances=" + this.getOutputWriterInstances() + ", typeNameValuesStringBuilder=" + this.typeNameValuesStringBuilder + ")";
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<String> getKeys() {
        return this.keys;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<String> getAttr() {
        return this.attr;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableSet<String> getTypeNames() {
        return this.typeNames;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getResultAlias() {
        return this.resultAlias;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUseObjDomainAsKey() {
        return this.useObjDomainAsKey;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isAllowDottedKeys() {
        return this.allowDottedKeys;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUseAllTypeNames() {
        return this.useAllTypeNames;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<OutputWriterFactory> getOutputWriters() {
        return this.outputWriters;
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public Iterable<OutputWriter> getOutputWriterInstances() {
        return this.outputWriterInstances;
    }

    @NotThreadSafe
    public static final class Builder {
        private String obj;
        private final List<String> attr = Lists.newArrayList();
        private String resultAlias;
        private final List<String> keys = Lists.newArrayList();
        private boolean useObjDomainAsKey;
        private boolean allowDottedKeys;
        private boolean useAllTypeNames;
        private final List<OutputWriterFactory> outputWriters = Lists.newArrayList();
        private final Set<String> typeNames = Sets.newHashSet();

        private Builder() {
        }

        public Builder addAttr(String ... attr) {
            this.attr.addAll(Arrays.asList(attr));
            return this;
        }

        public Builder addKey(String keys) {
            return this.addKeys(keys);
        }

        public Builder addKeys(String ... keys) {
            this.keys.addAll(Arrays.asList(keys));
            return this;
        }

        public Builder addOutputWriter(OutputWriterFactory outputWriter) {
            return this.addOutputWriters(outputWriter);
        }

        public Builder addOutputWriters(OutputWriterFactory ... outputWriters) {
            this.outputWriters.addAll(Arrays.asList(outputWriters));
            return this;
        }

        public Builder setTypeNames(Set<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Query build() {
            return new Query(this.obj, this.keys, this.attr, this.typeNames, this.resultAlias, this.useObjDomainAsKey, this.allowDottedKeys, this.useAllTypeNames, this.outputWriters);
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setObj(String obj) {
            this.obj = obj;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setResultAlias(String resultAlias) {
            this.resultAlias = resultAlias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setUseObjDomainAsKey(boolean useObjDomainAsKey) {
            this.useObjDomainAsKey = useObjDomainAsKey;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setAllowDottedKeys(boolean allowDottedKeys) {
            this.allowDottedKeys = allowDottedKeys;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setUseAllTypeNames(boolean useAllTypeNames) {
            this.useAllTypeNames = useAllTypeNames;
            return this;
        }
    }
}

