/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.naming.typename;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeNameValue {
    private String key;
    private String value;

    public TypeNameValue(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public TypeNameValue(String key) {
        this(key, "");
    }

    public static Iterable<TypeNameValue> extract(final String typeNameStr) {
        return new Iterable<TypeNameValue>(){

            @Override
            public Iterator<TypeNameValue> iterator() {
                return new TypeNameValuesIterator(typeNameStr);
            }
        };
    }

    public static Map<String, String> extractMap(String typeNameStr) {
        if (typeNameStr == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (TypeNameValue typeNameValue : TypeNameValue.extract(typeNameStr)) {
            result.put(typeNameValue.getKey(), typeNameValue.getValue());
        }
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeNameValue)) {
            return false;
        }
        TypeNameValue other = (TypeNameValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof TypeNameValue;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getValue() {
        return this.value;
    }

    private static class TypeNameValuesIterator
    implements Iterator<TypeNameValue> {
        private String[] tokens;
        private int iterator;

        public TypeNameValuesIterator(String typeNameStr) {
            this.tokens = typeNameStr.split(",");
            this.iterator = 0;
            this.skipEmpty();
        }

        @Override
        public boolean hasNext() {
            return this.iterator < this.tokens.length;
        }

        @Override
        public TypeNameValue next() {
            String[] keyVal = this.tokens[this.iterator].split("=", 2);
            TypeNameValue result = keyVal.length > 1 ? new TypeNameValue(keyVal[0], keyVal[1]) : new TypeNameValue(keyVal[0]);
            ++this.iterator;
            this.skipEmpty();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private void skipEmpty() {
            while (this.iterator < this.tokens.length && this.tokens[this.iterator].isEmpty()) {
                ++this.iterator;
            }
        }
    }
}

