/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.results.BooleanAsNumberValueTransformer;
import com.googlecode.jmxtrans.model.results.IdentityValueTransformer;
import com.googlecode.jmxtrans.model.results.ResultValuesTransformer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

public class ResultTransformerOutputWriter<T extends OutputWriter>
implements OutputWriter {
    @Nonnull
    private final ResultValuesTransformer resultValuesTransformer;
    @Nonnull
    private final T target;

    public ResultTransformerOutputWriter(@Nonnull ResultValuesTransformer resultValuesTransformer, @Nonnull T target) {
        this.resultValuesTransformer = resultValuesTransformer;
        this.target = target;
    }

    @Override
    public void start() throws LifecycleException {
    }

    @Override
    public void stop() throws LifecycleException {
    }

    @Override
    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        this.target.doWrite(server, query, (Iterable<Result>)FluentIterable.from(results).transform((Function)this.resultValuesTransformer).toList());
    }

    @Override
    public Map<String, Object> getSettings() {
        return Collections.emptyMap();
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
    }

    @Override
    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    public static <T extends OutputWriter> ResultTransformerOutputWriter<T> booleanToNumber(boolean booleanToNumber, T target) {
        if (booleanToNumber) {
            return ResultTransformerOutputWriter.booleanToNumber(target);
        }
        return ResultTransformerOutputWriter.identity(target);
    }

    public static <T extends OutputWriter> ResultTransformerOutputWriter<T> booleanToNumber(T target) {
        return new ResultTransformerOutputWriter<T>(new ResultValuesTransformer(new BooleanAsNumberValueTransformer(1, 0)), target);
    }

    public static <T extends OutputWriter> ResultTransformerOutputWriter<T> identity(T target) {
        return new ResultTransformerOutputWriter<T>(new ResultValuesTransformer(new IdentityValueTransformer()), target);
    }
}

