/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.guice;

import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.module.guice.ObjectMapperModule;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.googlecode.jmxtrans.cli.JmxTransConfiguration;
import com.googlecode.jmxtrans.connections.DatagramSocketFactory;
import com.googlecode.jmxtrans.connections.MBeanServerConnectionFactory;
import com.googlecode.jmxtrans.connections.SocketFactory;
import com.googlecode.jmxtrans.guice.GuiceJobFactory;
import com.googlecode.jmxtrans.monitoring.ManagedGenericKeyedObjectPool;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTransModule
extends AbstractModule {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JmxTransConfiguration configuration;

    public JmxTransModule(@Nonnull JmxTransConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<GenericKeyedObjectPool<InetSocketAddress, Socket>>(){}).toInstance(this.getObjectPool((KeyedPoolableObjectFactory)new SocketFactory(), SocketFactory.class.getSimpleName()));
        this.bind((TypeLiteral)new TypeLiteral<GenericKeyedObjectPool<SocketAddress, DatagramSocket>>(){}).toInstance(this.getObjectPool((KeyedPoolableObjectFactory)new DatagramSocketFactory(), DatagramSocketFactory.class.getSimpleName()));
        this.bind(KeyedObjectPool.class).annotatedWith((Annotation)Names.named((String)"mbeanPool")).toInstance(this.getObjectPool((KeyedPoolableObjectFactory)new MBeanServerConnectionFactory(), MBeanServerConnectionFactory.class.getSimpleName()));
    }

    @Provides
    JmxTransConfiguration jmxTransConfiguration() {
        return this.configuration;
    }

    @Provides
    @Inject
    Scheduler scheduler(JmxTransConfiguration configuration, GuiceJobFactory jobFactory) throws SchedulerException, IOException {
        StdSchedulerFactory serverSchedFact = new StdSchedulerFactory();
        try (Closer closer = Closer.create();){
            InputStream stream = configuration.getQuartzPropertiesFile() == null ? (InputStream)closer.register((Closeable)JmxTransModule.class.getResourceAsStream("/quartz.server.properties")) : (InputStream)closer.register((Closeable)new FileInputStream(configuration.getQuartzPropertiesFile()));
            serverSchedFact.initialize(stream);
        }
        Scheduler scheduler = serverSchedFact.getScheduler();
        scheduler.setJobFactory((JobFactory)jobFactory);
        return scheduler;
    }

    @Provides
    @Singleton
    @Named(value="queryProcessorExecutor")
    ThreadPoolExecutor queryProcessorExecutor() {
        int poolSize = this.configuration.getQueryProcessorExecutorPoolSize();
        int workQueueCapacity = this.configuration.getQueryProcessorExecutorWorkQueueCapacity();
        String componentName = "query";
        return this.createExecutorService(poolSize, workQueueCapacity, componentName);
    }

    @Provides
    @Singleton
    @Named(value="resultProcessorExecutor")
    ThreadPoolExecutor resultProcessorExecutor() {
        int poolSize = this.configuration.getResultProcessorExecutorPoolSize();
        int workQueueCapacity = this.configuration.getResultProcessorExecutorWorkQueueCapacity();
        String componentName = "result";
        return this.createExecutorService(poolSize, workQueueCapacity, componentName);
    }

    private ThreadPoolExecutor createExecutorService(int poolSize, int workQueueCapacity, String componentName) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(workQueueCapacity);
        ThreadFactory threadFactory = this.threadFactory(componentName);
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, workQueue, threadFactory);
    }

    private ThreadFactory threadFactory(String componentName) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("jmxtrans-" + componentName + "-%d").build();
    }

    private <K, V> GenericKeyedObjectPool<K, V> getObjectPool(KeyedPoolableObjectFactory<K, V> factory, String poolName) {
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(factory);
        pool.setTestOnBorrow(true);
        pool.setMaxActive(-1);
        pool.setMaxIdle(-1);
        pool.setTimeBetweenEvictionRunsMillis(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
        pool.setMinEvictableIdleTimeMillis(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
        try {
            ManagedGenericKeyedObjectPool mbean = new ManagedGenericKeyedObjectPool(pool, poolName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, mbean.getObjectName());
        }
        catch (Exception e) {
            this.log.error("Could not register mbean for pool [{}]", (Object)poolName, (Object)e);
        }
        return pool;
    }

    @Nonnull
    public static Injector createInjector(@Nonnull JmxTransConfiguration configuration) {
        return Guice.createInjector((Module[])new Module[]{new JmxTransModule(configuration), new ObjectMapperModule().registerModule((com.fasterxml.jackson.databind.Module)new GuavaModule())});
    }
}

