/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.naming;

import com.googlecode.jmxtrans.model.NamingStrategy;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.naming.typename.TypeNameValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlNamingStrategy
implements NamingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(JexlNamingStrategy.class);
    public static final String DEFAULT_EXPRESSION = "class + \".\" + attribute";
    public static final String VAR__CLASSNAME = "realclass";
    public static final String VAR__ATTRIBUTE_NAME = "attribute";
    public static final String VAR__CLASSNAME_ALIAS = "alias";
    public static final String VAR__EFFECTIVE_CLASSNAME = "class";
    public static final String VAR__TYPENAME = "typename";
    public static final String VAR__RESULT = "result";
    protected JexlEngine jexl = new JexlEngine();
    protected Expression parsedExpr;

    public JexlNamingStrategy() throws JexlException {
        this.parsedExpr = this.jexl.createExpression(DEFAULT_EXPRESSION);
    }

    public JexlNamingStrategy(String expr) throws JexlException {
        this.parsedExpr = this.jexl.createExpression(expr);
    }

    @Override
    public String formatName(Result result) {
        String formatted;
        MapContext context = new MapContext();
        this.populateContext((JexlContext)context, result);
        try {
            formatted = (String)this.parsedExpr.evaluate((JexlContext)context);
        }
        catch (JexlException jexlExc) {
            LOG.error("error applying JEXL expression to query results", (Throwable)jexlExc);
            formatted = null;
        }
        return formatted;
    }

    public void setExpression(String expr) throws JexlException {
        this.parsedExpr = this.jexl.createExpression(expr);
    }

    protected void populateContext(JexlContext context, Result result) {
        context.set(VAR__CLASSNAME, (Object)result.getClassName());
        context.set(VAR__ATTRIBUTE_NAME, (Object)result.getAttributeName());
        context.set(VAR__CLASSNAME_ALIAS, (Object)result.getKeyAlias());
        Map<String, String> typeNameMap = TypeNameValue.extractMap(result.getTypeName());
        context.set(VAR__TYPENAME, typeNameMap);
        String effectiveClassname = result.getKeyAlias();
        if (effectiveClassname == null) {
            effectiveClassname = result.getClassName();
        }
        context.set(VAR__EFFECTIVE_CLASSNAME, (Object)effectiveClassname);
        context.set(VAR__RESULT, (Object)result);
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JexlNamingStrategy)) {
            return false;
        }
        JexlNamingStrategy other = (JexlNamingStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JexlEngine this$jexl = this.jexl;
        JexlEngine other$jexl = other.jexl;
        if (this$jexl == null ? other$jexl != null : !this$jexl.equals(other$jexl)) {
            return false;
        }
        Expression this$parsedExpr = this.parsedExpr;
        Expression other$parsedExpr = other.parsedExpr;
        return !(this$parsedExpr == null ? other$parsedExpr != null : !this$parsedExpr.equals(other$parsedExpr));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof JexlNamingStrategy;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JexlEngine $jexl = this.jexl;
        result = result * 59 + ($jexl == null ? 43 : $jexl.hashCode());
        Expression $parsedExpr = this.parsedExpr;
        result = result * 59 + ($parsedExpr == null ? 43 : $parsedExpr.hashCode());
        return result;
    }
}

