/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;

public final class ServerFixtures {
    public static final String DEFAULT_HOST = "host.example.net";
    public static final String DEFAULT_PORT = "4321";

    private ServerFixtures() {
    }

    public static Server createServerWithOneQuery(String host, String port, String queryObject) {
        return Server.builder().setHost(host).setPort(port).addQuery(Query.builder().setObj(queryObject).build()).build();
    }

    public static Server serverWithNoQuery() {
        return Server.builder().setHost(DEFAULT_HOST).setPort(DEFAULT_PORT).build();
    }

    public static Server dummyServer() {
        return ServerFixtures.createServerWithOneQuery(DEFAULT_HOST, DEFAULT_PORT, "myQuery:key=val");
    }

    public static Server localServer() {
        return Server.builder().setHost(DEFAULT_HOST).setPort(DEFAULT_PORT).setLocal(true).build();
    }
}

