/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.ServerListBuilder;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationParser.class);
    private final JsonUtils jsonUtils;

    @Inject
    public ConfigurationParser(JsonUtils jsonUtils) {
        this.jsonUtils = jsonUtils;
    }

    public ImmutableList parseServers(Iterable<File> jsonFiles, boolean continueOnJsonError) throws LifecycleException {
        ServerListBuilder serverListBuilder = new ServerListBuilder();
        for (File jsonFile : jsonFiles) {
            try {
                JmxProcess process = this.jsonUtils.parseProcess(jsonFile);
                log.debug("Loaded file: {}", (Object)jsonFile.getAbsolutePath());
                serverListBuilder.add((Iterable<Server>)process.getServers());
            }
            catch (Exception ex) {
                String message = "Error parsing json: " + jsonFile;
                if (continueOnJsonError) {
                    log.error(message, (Throwable)ex);
                    continue;
                }
                throw new LifecycleException(message, ex);
            }
        }
        return serverListBuilder.build();
    }

    @CheckReturnValue
    @VisibleForTesting
    ImmutableList<Server> mergeServerLists(List<Server> firstList, List<Server> secondList) {
        ImmutableList.Builder results = ImmutableList.builder();
        ArrayList<Server> toProcess = new ArrayList<Server>(secondList);
        for (Server firstServer : firstList) {
            if (toProcess.contains(firstServer)) {
                Server found = (Server)toProcess.get(secondList.indexOf(firstServer));
                results.add((Object)this.merge(firstServer, found));
                toProcess.remove(found);
                continue;
            }
            results.add((Object)firstServer);
        }
        results.addAll(toProcess);
        return results.build();
    }

    private Server merge(Server firstServer, Server secondServer) {
        return Server.builder(firstServer).addQueries((Set<Query>)secondServer.getQueries()).build();
    }
}

