/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.connections;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketFactory
extends BaseKeyedPoolableObjectFactory<InetSocketAddress, Socket> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Socket makeObject(InetSocketAddress address) throws Exception {
        Socket socket = new Socket(address.getHostName(), address.getPort());
        socket.setKeepAlive(true);
        return socket;
    }

    public void destroyObject(InetSocketAddress address, Socket socket) throws Exception {
        socket.close();
    }

    public boolean validateObject(InetSocketAddress address, Socket socket) {
        if (socket == null) {
            this.log.error("Socket is null [{}]", (Object)address);
            return false;
        }
        if (!socket.isBound()) {
            this.log.error("Socket is not bound [{}]", (Object)address);
            return false;
        }
        if (socket.isClosed()) {
            this.log.error("Socket is closed [{}]", (Object)address);
            return false;
        }
        if (!socket.isConnected()) {
            this.log.error("Socket is not connected [{}]", (Object)address);
            return false;
        }
        if (socket.isInputShutdown()) {
            this.log.error("Socket input is shutdown [{}]", (Object)address);
            return false;
        }
        if (socket.isOutputShutdown()) {
            this.log.error("Socket output is shutdown [{}]", (Object)address);
            return false;
        }
        return true;
    }
}

