/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jmx;

import com.googlecode.jmxtrans.jmx.ProcessQueryThread;
import com.googlecode.jmxtrans.jmx.ResultProcessor;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(JmxUtils.class);
    @Nonnull
    private final ThreadPoolExecutor executorService;
    @Nonnull
    private final ResultProcessor resultProcessor;

    @Inject
    public JmxUtils(@Named(value="queryProcessorExecutor") @Nonnull ThreadPoolExecutor executorService, @Nonnull ResultProcessor resultProcessor) {
        this.executorService = executorService;
        this.resultProcessor = resultProcessor;
    }

    public void processServer(Server server) throws Exception {
        for (Query query : server.getQueries()) {
            ProcessQueryThread pqt = new ProcessQueryThread(this.resultProcessor, server, query);
            try {
                this.executorService.submit(pqt);
            }
            catch (RejectedExecutionException ree) {
                logger.error("Could not submit query {}. You could try to size the 'queryProcessorExecutor' to a larger size.", (Object)pqt, (Object)ree);
            }
        }
    }
}

