/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.jmx;

import com.googlecode.jmxtrans.jmx.ResultProcessor;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessQueryThread
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final Server server;
    @Nonnull
    private final Query query;
    @Nonnull
    private final ResultProcessor resultProcessor;

    public ProcessQueryThread(@Nonnull ResultProcessor resultProcessor, @Nonnull Server server, @Nonnull Query query) {
        this.resultProcessor = resultProcessor;
        this.server = server;
        this.query = query;
    }

    @Override
    public void run() {
        try {
            Iterable<Result> results = this.server.execute(this.query);
            this.resultProcessor.submit(this.server, this.query, results);
        }
        catch (Exception e) {
            this.log.error("Error executing query {} on server {}", new Object[]{this.query, this.server, e});
            throw new RuntimeException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ProcessQueryThread(log=" + this.log + ", server=" + this.server + ", query=" + this.query + ")";
    }
}

