/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Server;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class JmxProcess {
    private String name;
    private ImmutableList<Server> servers;
    private Integer numMultiThreadedServers;

    public JmxProcess() {
        this((ImmutableList<Server>)ImmutableList.of());
    }

    public JmxProcess(Server server) {
        this.servers = ImmutableList.of((Object)server);
    }

    public JmxProcess(ImmutableList<Server> servers) {
        this.setServers((List<Server>)servers);
    }

    public void setServers(List<Server> servers) {
        this.servers = ImmutableList.copyOf(servers);
    }

    public ImmutableList<Server> getServers() {
        return this.servers;
    }

    @JsonIgnore
    public boolean isServersMultiThreaded() {
        return this.numMultiThreadedServers != null && this.numMultiThreadedServers > 0;
    }

    public void setNumMultiThreadedServers(Integer numMultiThreadedServers) {
        this.numMultiThreadedServers = numMultiThreadedServers;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    public Integer getNumMultiThreadedServers() {
        return this.numMultiThreadedServers;
    }
}

