/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model;

import com.googlecode.jmxtrans.model.Result;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public enum ResultAttribute {
    TYPE_NAME("typeName"),
    OBJ_DOMAIN("objDomain"),
    CLASS_NAME("className"),
    ATTRIBUTE_NAME("attributeName");

    @Nonnull
    private String attributeName;
    @Nonnull
    private String accessorMethod;

    private ResultAttribute(String attributeName) {
        this.attributeName = attributeName;
        this.accessorMethod = "get" + StringUtils.capitalize((String)attributeName);
    }

    public static ResultAttribute fromAttribute(@Nonnull String attributeName) {
        String[] split = StringUtils.splitByCharacterTypeCamelCase((String)attributeName);
        StringBuilder sb = new StringBuilder(split[0].toUpperCase()).append("_").append(split[1].toUpperCase());
        return ResultAttribute.valueOf(sb.toString());
    }

    public void addAttribute(@Nonnull Map<String, String> attributeMap, @Nonnull Result result) {
        Method m = result.getClass().getMethod(this.accessorMethod, new Class[0]);
        attributeMap.put(this.attributeName, (String)m.invoke((Object)result, new Object[0]));
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ResultAttribute(attributeName=" + this.attributeName + ", accessorMethod=" + this.accessorMethod + ")";
    }
}

