/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.naming;

import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern DOT_SLASH_UNDERSCORE_PAT = Pattern.compile("[./]");
    private static final Pattern SLASH_UNDERSCORE_PAT = Pattern.compile("/", 16);
    private static final Pattern SPACE_PAT = Pattern.compile("[ \"']+");

    private StringUtils() {
    }

    public static String cleanupStr(String name) {
        return StringUtils.cleanupStr(name, false);
    }

    public static String cleanupStr(String name, boolean allowDottedKeys) {
        if (name == null) {
            return null;
        }
        Pattern pattern = !allowDottedKeys ? DOT_SLASH_UNDERSCORE_PAT : SLASH_UNDERSCORE_PAT;
        String clean = pattern.matcher(name).replaceAll("_");
        clean = SPACE_PAT.matcher(clean).replaceAll("");
        clean = org.apache.commons.lang.StringUtils.chomp((String)clean, (String)".");
        clean = org.apache.commons.lang.StringUtils.chomp((String)clean, (String)"_");
        return clean;
    }
}

