/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.naming.typename;

import com.googlecode.jmxtrans.model.naming.typename.TypeNameValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class TypeNameValuesStringBuilder {
    public static final String DEFAULT_SEPARATOR = "_";
    private static final TypeNameValuesStringBuilder defaultBuilder = new TypeNameValuesStringBuilder();
    private final String separator;

    public TypeNameValuesStringBuilder() {
        this(DEFAULT_SEPARATOR);
    }

    public TypeNameValuesStringBuilder(String separator) {
        this.separator = separator;
    }

    public String build(List<String> typeNames, String typeNameStr) {
        return this.doBuild(typeNames, typeNameStr);
    }

    public static TypeNameValuesStringBuilder getDefaultBuilder() {
        return defaultBuilder;
    }

    protected final String doBuild(List<String> typeNames, String typeNameStr) {
        if (typeNames == null || typeNames.isEmpty()) {
            return null;
        }
        Map<String, String> typeNameValueMap = TypeNameValue.extractMap(typeNameStr);
        StringBuilder sb = new StringBuilder();
        for (String key : typeNames) {
            String result = typeNameValueMap.get(key);
            if (result == null) continue;
            sb.append(result);
            sb.append(this.separator);
        }
        return StringUtils.chomp((String)sb.toString(), (String)this.separator);
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeNameValuesStringBuilder)) {
            return false;
        }
        TypeNameValuesStringBuilder other = (TypeNameValuesStringBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$separator = this.separator;
        String other$separator = other.separator;
        return !(this$separator == null ? other$separator != null : !this$separator.equals(other$separator));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof TypeNameValuesStringBuilder;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $separator = this.separator;
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "TypeNameValuesStringBuilder(separator=" + this.separator + ")";
    }
}

