/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import java.util.Map;

public final class Settings {
    private Settings() {
    }

    public static Boolean getBooleanSetting(Map<String, Object> settings, String key) {
        return Settings.getBooleanSetting(settings, key, false);
    }

    public static Boolean getBooleanSetting(Map<String, Object> settings, String key, Boolean defaultVal) {
        Object value = settings.get(key);
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return defaultVal;
    }

    public static Integer getIntegerSetting(Map<String, Object> settings, String key, Integer defaultVal) {
        Object value = settings.get(key);
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static String getStringSetting(Map<String, Object> settings, String key, String defaultVal) {
        Object value = settings.get(key);
        return value != null ? value.toString() : defaultVal;
    }

    protected static int getIntSetting(Map<String, Object> settings, String key, int defaultVal) throws IllegalArgumentException {
        if (settings.containsKey(key)) {
            Object objectValue = settings.get(key);
            if (objectValue == null) {
                throw new IllegalArgumentException("Setting '" + key + " null");
            }
            String value = objectValue.toString();
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Setting '" + key + "=" + value + "' is not an integer", e);
            }
        }
        return defaultVal;
    }
}

